/*
 * Decompiled with CFR 0.152.
 */
package bs;

import bs.Player;
import bswfx.BomberStudent;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Game {
    protected HashMap<Integer, Player> player = new HashMap();
    protected int mainPlayer;
    protected int width;
    protected int height;
    protected String[][] map;

    public Game(JSONObject jo) {
        JSONObject joMap = jo.getJSONObject("map");
        this.width = joMap.getInt("width");
        this.height = joMap.getInt("height");
        this.map = this.parseMap(joMap.getString("content"));
        JSONObject joPlayer = jo.getJSONObject("player");
        Player p = new Player(joPlayer, jo.getString("startPos"));
        this.player.put(joPlayer.getInt("id"), p);
        this.map[p.getX()][p.getY()] = "" + p.getId();
        this.mainPlayer = p.getId();
        if (jo.has("players")) {
            JSONArray ja = jo.getJSONArray("players");
            for (int i = 0; i < ja.length(); ++i) {
                joPlayer = ja.getJSONObject(i);
                int id = joPlayer.getInt("id");
                if (id == this.mainPlayer) continue;
                p = new Player(id, joPlayer.getString("pos"));
                this.player.put(id, p);
                this.map[p.getX()][p.getY()] = "" + id;
            }
        }
    }

    public void join(int id, String pos) {
        Player p = new Player(id, pos);
        this.player.put(id, p);
        this.map[p.getX()][p.getY()] = "" + id;
    }

    public boolean move(int player, int dir) {
        Player p = this.player.get(player);
        if (p == null) {
            return false;
        }
        int x = p.getX();
        int y = p.getY();
        switch (dir) {
            case 0: {
                if (y <= 0) break;
                --y;
                break;
            }
            case 1: {
                if (x <= 0) break;
                --x;
                break;
            }
            case 2: {
                if (y >= this.height - 1) break;
                ++y;
                break;
            }
            case 3: {
                if (x >= this.width - 1) break;
                ++x;
                break;
            }
            default: {
                return false;
            }
        }
        switch (this.map[x][y]) {
            case "cb": {
                this.getObject(0);
                break;
            }
            case "mb": {
                this.getObject(1);
                break;
            }
            case "rb": {
                this.getObject(2);
                break;
            }
            case "bu": {
                this.getObject(3);
                break;
            }
            case "bd": {
                this.getObject(4);
                break;
            }
            case "f": {
                this.getObject(5);
                break;
            }
            case "s": {
                this.getObject(6);
                break;
            }
            case "bl": {
                this.getObject(7);
                break;
            }
            case "i": {
                this.getObject(8);
                break;
            }
            case "lm": {
                this.getObject(10);
                break;
            }
            case "lu": {
                this.getObject(9);
            }
        }
        p.setDir(dir);
        this.map[x][y] = "" + p.getId();
        this.map[p.getX()][p.getY()] = "_";
        p.setX(x);
        p.setY(y);
        return true;
    }

    public boolean newBomb(int type, String coord) {
        int[] pos = this.parseCoord(coord);
        switch (type) {
            case 0: {
                this.map[pos[0]][pos[1]] = "b";
                break;
            }
            case 1: {
                this.map[pos[0]][pos[1]] = "m";
                break;
            }
            case 2: {
                this.map[pos[0]][pos[1]] = "r";
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void removeBomb(String coord) {
        int[] pos = this.parseCoord(coord);
        if (this.map[pos[0]][pos[1]].equals("b") || this.map[pos[0]][pos[1]].equals("m") || this.map[pos[0]][pos[1]].equals("r")) {
            this.map[pos[0]][pos[1]] = "_";
        }
    }

    public boolean newObject(int type, String coord) {
        int[] pos = this.parseCoord(coord);
        switch (type) {
            case 0: {
                this.map[pos[0]][pos[1]] = "cb";
                break;
            }
            case 1: {
                this.map[pos[0]][pos[1]] = "mb";
                break;
            }
            case 2: {
                this.map[pos[0]][pos[1]] = "rb";
                break;
            }
            case 3: {
                this.map[pos[0]][pos[1]] = "bu";
                break;
            }
            case 4: {
                this.map[pos[0]][pos[1]] = "bd";
                break;
            }
            case 5: {
                this.map[pos[0]][pos[1]] = "f";
                break;
            }
            case 6: {
                this.map[pos[0]][pos[1]] = "s";
                break;
            }
            case 7: {
                this.map[pos[0]][pos[1]] = "bl";
                break;
            }
            case 8: {
                this.map[pos[0]][pos[1]] = "i";
                break;
            }
            case 9: {
                this.map[pos[0]][pos[1]] = "lu";
                break;
            }
            case 10: {
                this.map[pos[0]][pos[1]] = "lm";
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean getObject(int type) {
        JSONObject param = new JSONObject();
        switch (type) {
            case 0: {
                param.put("type", (Object)"bomb");
                param.put("class", (Object)"classic");
                break;
            }
            case 1: {
                param.put("type", (Object)"bomb");
                param.put("class", (Object)"mine");
                break;
            }
            case 2: {
                param.put("type", (Object)"bomb");
                param.put("class", (Object)"remote");
                break;
            }
            case 3: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"bomb_up");
                break;
            }
            case 4: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"bomb_down");
                break;
            }
            case 5: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"fire_power");
                break;
            }
            case 6: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"scooter");
                break;
            }
            case 7: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"broken_legs");
                break;
            }
            case 8: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"major");
                break;
            }
            case 9: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"life_up");
                break;
            }
            case 10: {
                param.put("type", (Object)"bonusMalus");
                param.put("class", (Object)"life_max");
                break;
            }
            default: {
                return false;
            }
        }
        if (!BomberStudent.bsc.send("POST", "object/new", param)) {
            return false;
        }
        JSONObject res = BomberStudent.bsc.receive();
        if (res.getInt("status") != 201) {
            return false;
        }
        Player p = this.player.get(this.mainPlayer);
        p.setLife(res.getInt("life"));
        p.setMaxLife(res.getInt("maxLife"));
        p.setSpeed(res.getInt("speed"));
        p.setBomb(res.getInt("currentNbClassicBomb"));
        p.setMine(res.getInt("currentNbMine"));
        p.setRemote(res.getInt("currentNbRemoteBomb"));
        p.setMaxBomb(res.getInt("maxNbBomb"));
        if (type == 5) {
            p.setFirepower(p.getFirepower() + 1);
        } else if (type == 8) {
            System.out.println("Get major");
        }
        return true;
    }

    public void updateMap(String mapContent) {
        String[][] map = this.parseMap(mapContent);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (!this.map[j][i].equals("*")) continue;
                this.map[j][i] = map[j][i];
            }
        }
    }

    public void updateLife(int newLife) {
        Player p = this.player.get(this.mainPlayer);
        if (!p.isMajor()) {
            if (newLife > 0) {
                p.setLife(newLife);
            } else {
                BomberStudent.end();
            }
        }
    }

    public boolean quit(int id) {
        Player p = this.player.get(id);
        if (p == null) {
            return false;
        }
        this.player.remove(id);
        this.map[p.getX()][p.getY()] = "_";
        return true;
    }

    public String toHtml() {
        String html = "<!DOCTYPE html><html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"file:" + System.getProperty("user.dir") + "/file/css/map.css\"></head><body><div id=\"game\"><table><tbody>";
        for (int i = 0; i < this.height; ++i) {
            html = html + "<tr>";
            for (int j = 0; j < this.width; ++j) {
                html = html + "<td><img src=\"file:" + System.getProperty("user.dir") + "/";
                block0 : switch (this.map[j][i].charAt(0)) {
                    case '_': {
                        html = html + "file/sprite/sol.png";
                        break;
                    }
                    case '-': {
                        html = html + "file/sprite/limite.png";
                        break;
                    }
                    case '*': {
                        html = html + "file/sprite/mur.png";
                        break;
                    }
                    case 'b': {
                        switch (this.map[j][i]) {
                            case "bu": {
                                html = html + "file/sprite/bomb_up.png";
                                break block0;
                            }
                            case "bd": {
                                html = html + "file/sprite/bomb_down.png";
                                break block0;
                            }
                            case "bl": {
                                html = html + "file/sprite/broken_leg.png";
                                break block0;
                            }
                        }
                        html = html + "file/sprite/bomb.png";
                        break;
                    }
                    case 'm': {
                        switch (this.map[j][i]) {
                            case "mb": {
                                html = html + "file/sprite/mine_bomb.png";
                                break block0;
                            }
                        }
                        html = html + "file/sprite/mine.png";
                        break;
                    }
                    case 'r': {
                        switch (this.map[j][i]) {
                            case "rb": {
                                html = html + "file/sprite/remote_bomb.png";
                                break block0;
                            }
                        }
                        html = html + "file/sprite/remote.png";
                        break;
                    }
                    case 'c': {
                        html = html + "file/sprite/classic_bomb.png";
                        break;
                    }
                    case 'f': {
                        html = html + "file/sprite/fire_power.png";
                        break;
                    }
                    case 's': {
                        html = html + "file/sprite/scooter.png";
                        break;
                    }
                    case 'i': {
                        html = html + "file/sprite/major.png";
                        break;
                    }
                    case 'l': {
                        switch (this.map[j][i]) {
                            case "lu": {
                                html = html + "file/sprite/life_up.png";
                                break block0;
                            }
                        }
                        html = html + "file/sprite/life_max.png";
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        Player p = this.player.get(Integer.parseInt(this.map[j][i]));
                        html = p.main ? html + "file/sprite/player.png" : html + "file/sprite/other.png";
                    }
                }
                html = html + "\"></td>";
            }
            html = html + "</tr>";
        }
        html = html + "</tbody></table></div></body></html>";
        return html;
    }

    public void showMap() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                System.out.print(this.map[j][i]);
            }
            System.out.println("");
        }
    }

    public Player getPlayer(int index) {
        return this.player.get(index);
    }

    public int getMainPlayerId() {
        return this.mainPlayer;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private String[][] parseMap(String mapContent) {
        String[][] map = new String[this.width][this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                map[j][i] = "" + mapContent.charAt(i * this.width + j);
            }
        }
        return map;
    }

    private int[] parseCoord(String coord) {
        int pos;
        int[] res = new int[2];
        for (pos = 0; pos < coord.length() && coord.charAt(pos) != ','; ++pos) {
        }
        if (pos == coord.length()) {
            return null;
        }
        String substr1 = coord.substring(0, pos);
        String substr2 = coord.substring(pos + 1);
        res[0] = Integer.parseInt(substr1);
        res[1] = Integer.parseInt(substr2);
        return res;
    }
}

