/*
 * Decompiled with CFR 0.152.
 */
package wfx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import wfx.WebFx;

public class WebFxConfig {
    private static WebFxConfig instance;
    protected boolean ini = false;
    protected String path = "file/webfx/config.json";
    protected JSONObject json;

    public static WebFxConfig getInstance() throws IllegalArgumentException {
        if (instance == null) {
            instance = new WebFxConfig();
        }
        return instance;
    }

    public static WebFxConfig getInstance(String path) throws IllegalArgumentException {
        if (instance == null) {
            instance = new WebFxConfig(path);
        }
        return instance;
    }

    private WebFxConfig() {
        if (this.path != null) {
            this.ini = true;
            String content = this.fileGetContent(this.path);
            if (content == null) {
                throw new IllegalArgumentException("Fichier introuvable");
            }
            try {
                this.json = new JSONObject(content);
            }
            catch (JSONException ex) {
                throw new IllegalArgumentException("JSON invalide");
            }
        }
    }

    private WebFxConfig(String configPath) {
        File f = new File(configPath);
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("Fichier introuvable");
        }
        this.ini = true;
        this.path = configPath;
        String content = this.fileGetContent(this.path);
        if (content == null) {
            throw new IllegalArgumentException("Fichier introuvable");
        }
        try {
            this.json = new JSONObject(content);
        }
        catch (JSONException ex) {
            throw new IllegalArgumentException("JSON invalide");
        }
    }

    public void setUpWebFx(WebFx wfx) {
        if (!this.ini) {
            return;
        }
        if (this.json.has("title")) {
            wfx.setTitle(this.json.getString("title"));
        }
        if (this.json.has("defaultHtml")) {
            JSONObject jo = this.json.getJSONObject("defaultHtml");
            if (jo.getBoolean("file")) {
                wfx.setHtmlFile(jo.getString("html"));
            } else {
                wfx.setHtml(jo.getString("html"));
            }
        }
        if (this.json.has("icon")) {
            wfx.setIcon(this.json.getString("icon"));
        }
        if (this.json.has("width") && this.json.has("height")) {
            wfx.setSize(this.json.getInt("width"), this.json.getInt("height"));
        }
    }

    private String fileGetContent(String path) {
        File f = new File(path);
        if (!f.exists() || !f.canRead()) {
            return null;
        }
        String fileContent = "";
        try {
            String buf;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((buf = br.readLine()) != null) {
                fileContent = fileContent + buf;
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println("Le fichier est introuvable : " + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            System.err.println("Impossible de lire le fichier : " + ex.getMessage());
            return null;
        }
        return fileContent;
    }
}

