/*
 * Decompiled with CFR 0.152.
 */
package bs;

import bswfx.BomberStudent;
import org.json.JSONObject;

public class Player {
    public static final int UP = 0;
    public static final int LEFT = 1;
    public static final int DOWN = 2;
    public static final int RIGHT = 3;
    public static final int CLASSIC = 0;
    public static final int MINE = 1;
    public static final int REMOTE = 2;
    public static final int BOMBUP = 3;
    public static final int BOMBDOWN = 4;
    public static final int FIREPOWER = 5;
    public static final int SCOOTER = 6;
    public static final int BROKENLEG = 7;
    public static final int MAJOR = 8;
    public static final int LIFEUP = 9;
    public static final int LIFEMAX = 10;
    protected boolean main;
    protected int id;
    protected int dir;
    protected int x;
    protected int y;
    protected int life;
    protected int maxLife;
    protected int speed;
    protected int maxBomb;
    protected int bomb;
    protected int mine;
    protected int remote;
    protected int firepower;
    protected boolean major;

    public Player(int id, String pos) {
        int[] coord = this.parseCoord(pos);
        this.main = false;
        this.id = id;
        this.dir = 3;
        this.x = coord[0];
        this.y = coord[1];
    }

    public Player(JSONObject jo, String pos) {
        int[] coord = this.parseCoord(pos);
        this.main = true;
        this.id = jo.getInt("id");
        this.dir = 3;
        this.x = coord[0];
        this.y = coord[1];
        this.life = jo.getInt("life");
        this.maxLife = jo.getInt("maxLife");
        this.speed = jo.getInt("speed");
        this.maxBomb = jo.getInt("maxNbBomb");
        this.bomb = jo.getInt("currentNbClassicBomb");
        this.mine = jo.getInt("currentNbMine");
        this.remote = jo.getInt("currentNbRemoteBomb");
        this.firepower = 0;
        this.major = false;
    }

    public boolean move(int dir) {
        JSONObject jo = new JSONObject();
        switch (dir) {
            case 0: {
                jo.put("move", (Object)"up");
                return BomberStudent.bsc.send("POST", "player/move", jo);
            }
            case 1: {
                jo.put("move", (Object)"left");
                return BomberStudent.bsc.send("POST", "player/move", jo);
            }
            case 2: {
                jo.put("move", (Object)"down");
                return BomberStudent.bsc.send("POST", "player/move", jo);
            }
            case 3: {
                jo.put("move", (Object)"right");
                return BomberStudent.bsc.send("POST", "player/move", jo);
            }
        }
        return false;
    }

    public boolean attack(int type) {
        JSONObject jo = new JSONObject();
        int x = this.x;
        int y = this.y;
        switch (this.dir) {
            case 0: {
                if (y == 0) {
                    return false;
                }
                --y;
                break;
            }
            case 1: {
                if (x == 0) {
                    return false;
                }
                --x;
                break;
            }
            case 2: {
                if (y == BomberStudent.game.getHeight() - 1) {
                    return false;
                }
                ++y;
                break;
            }
            case 3: {
                if (x == BomberStudent.game.getWidth() - 1) {
                    return false;
                }
                ++x;
                break;
            }
            default: {
                return false;
            }
        }
        jo.put("pos", (Object)(x + "," + y));
        switch (type) {
            case 0: {
                jo.put("class", (Object)"classic");
                break;
            }
            case 1: {
                jo.put("class", (Object)"mine");
                break;
            }
            case 2: {
                jo.put("class", (Object)"remote");
                break;
            }
            default: {
                return false;
            }
        }
        jo.put("bonus", this.firepower > 0);
        if (!BomberStudent.bsc.send("POST", "attack/bomb", jo)) {
            return false;
        }
        JSONObject res = BomberStudent.bsc.receive();
        if (res.getInt("status") == 201) {
            if (type == 1) {
                BomberStudent.game.newBomb(1, x + "," + y);
                BomberStudent.updateWindow();
            }
            return true;
        }
        return false;
    }

    public boolean isMain() {
        return this.main;
    }

    public int getId() {
        return this.id;
    }

    public int getDir() {
        return this.dir;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getLife() {
        return this.life;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getMaxBomb() {
        return this.maxBomb;
    }

    public int getBomb() {
        return this.bomb;
    }

    public int getMine() {
        return this.mine;
    }

    public int getRemote() {
        return this.remote;
    }

    public int getFirepower() {
        return this.firepower;
    }

    public boolean isMajor() {
        return this.major;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDir(int dir) {
        this.dir = dir;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setLife(int life) {
        this.life = life;
    }

    public void setMaxLife(int maxLife) {
        this.maxLife = maxLife;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setMaxBomb(int maxBomb) {
        this.maxBomb = maxBomb;
    }

    public void setBomb(int bomb) {
        this.bomb = bomb;
    }

    public void setMine(int mine) {
        this.mine = mine;
    }

    public void setRemote(int remote) {
        this.remote = remote;
    }

    public void setFirepower(int firepower) {
        this.firepower = firepower;
    }

    public void setMajor(boolean major) {
        this.major = major;
    }

    private int[] parseCoord(String coord) {
        int pos;
        int[] res = new int[2];
        for (pos = 0; pos < coord.length() && coord.charAt(pos) != ','; ++pos) {
        }
        if (pos == coord.length()) {
            return null;
        }
        String substr1 = coord.substring(0, pos);
        String substr2 = coord.substring(pos + 1);
        res[0] = Integer.parseInt(substr1);
        res[1] = Integer.parseInt(substr2);
        return res;
    }
}

