/*
 * Decompiled with CFR 0.152.
 */
package rsx.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class Broadcast {
    protected int port;
    protected String msg;
    protected int timeout = 5000;
    protected int bufferSize = 1024;
    protected ArrayList<InetAddress> servers = new ArrayList();

    public Broadcast(int port) {
        this.port = port;
        this.msg = "looking for bomberstudent servers";
    }

    public Broadcast(int port, String msg) {
        this.port = port;
        this.msg = msg;
    }

    public boolean search(String answer) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            socket.setBroadcast(true);
            socket.setSoTimeout(this.timeout);
        }
        catch (SocketException ex) {
            System.err.println("Erreur creation de la socket : " + ex.getMessage());
            return false;
        }
        byte[] buffer = this.msg.getBytes();
        try {
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length, InetAddress.getByName("255.255.255.255"), this.port);
            socket.send(packet);
        }
        catch (UnknownHostException ex) {
            System.err.println("Erreur hote inconnu : " + ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            System.err.println("Erreur IO : " + ex.getMessage());
            return false;
        }
        try {
            while (true) {
                byte[] tampon = new byte[this.bufferSize];
                DatagramPacket dp = new DatagramPacket(tampon, tampon.length);
                socket.receive(dp);
                String reponse = new String(dp.getData(), 0, dp.getLength());
                if (!reponse.equals(answer)) continue;
                this.servers.add(dp.getAddress());
            }
        }
        catch (SocketTimeoutException tampon) {
        }
        catch (IOException ex) {
            System.err.println("Erreur IO : " + ex.getMessage());
            return false;
        }
        socket.close();
        return true;
    }

    public void clean() {
        this.servers = new ArrayList();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public ArrayList<InetAddress> getServers() {
        return new ArrayList<InetAddress>(this.servers);
    }
}

