/*
 * Decompiled with CFR 0.152.
 */
package wfx;

import bswfx.BomberStudent;
import bswfx.KeyHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import wfx.WebFxConfig;

public class WebFx
extends Application
implements Runnable {
    public static Stage stage;
    public static AtomicBoolean ini;
    public static AtomicBoolean wait;
    protected double zoom = 1.0;
    protected int width = 800;
    protected int height = 800;
    protected String title = "WFX";
    protected String html = "<div style=\"margin-top: 48vh\"><h1 style=\"font-family: Arial\"><div style=\"text-align: center\">Loading...</div></h1></div>";
    protected String icon = null;

    public WebFx() {
        WebFxConfig config = WebFxConfig.getInstance();
        config.setUpWebFx(this);
    }

    public WebFx(String configPath) {
        WebFxConfig config = WebFxConfig.getInstance(configPath);
        config.setUpWebFx(this);
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public void setHtmlFile(String htmlFile) {
        String content = this.fileGetContent(htmlFile);
        if (content != null) {
            this.html = content;
        }
    }

    public void setIcon(String path) {
        this.icon = "file:" + path;
    }

    public void launch() {
        Application.launch((String[])new String[0]);
    }

    public void end() {
        Platform.exit();
    }

    public void start(Stage stage) {
        WebView wv = new WebView();
        VBox root = new VBox();
        wv.setZoom(this.zoom);
        wv.setMinWidth((double)this.width);
        wv.setMinHeight((double)this.height);
        root.setMinWidth((double)this.width);
        root.setMinHeight((double)this.height);
        WebFx.stage = stage;
        wv.getEngine().loadContent(this.html);
        root.getChildren().add((Object)wv);
        Scene scene = new Scene((Parent)root);
        WebFx.stage.setScene(scene);
        WebFx.stage.setTitle(this.title);
        if (this.icon != null) {
            WebFx.stage.getIcons().add((Object)new Image(this.icon));
        }
        WebFx.stage.setOnCloseRequest(event -> BomberStudent.end());
        wv.setOnKeyPressed(keyEvent -> KeyHandler.manage(keyEvent));
        WebFx.stage.show();
        ini.set(true);
    }

    public void loadHtml(final String html) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VBox v = (VBox)stage.getScene().getRoot();
                WebView wv = (WebView)v.getChildren().get(0);
                wv.getEngine().loadContent(html);
            }
        });
    }

    public boolean loadFile(String path) {
        String fileContent = this.fileGetContent(path);
        if (fileContent == null) {
            return false;
        }
        this.loadHtml(fileContent);
        return true;
    }

    public void alert(final String title, final String text) {
        wait.set(true);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle(title);
                alert.setHeaderText(null);
                alert.setContentText(text);
                alert.showAndWait();
                wait.set(false);
            }
        });
    }

    @Override
    public void run() {
        this.launch();
    }

    private String fileGetContent(String path) {
        File f = new File(path);
        if (!f.exists() || !f.canRead()) {
            return null;
        }
        String fileContent = "";
        try {
            String buf;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((buf = br.readLine()) != null) {
                fileContent = fileContent + buf;
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            System.err.println("Le fichier est introuvable : " + ex.getMessage());
            return null;
        }
        catch (IOException ex) {
            System.err.println("Impossible de lire le fichier : " + ex.getMessage());
            return null;
        }
        return fileContent;
    }

    static {
        ini = new AtomicBoolean(false);
        wait = new AtomicBoolean(false);
    }
}

