/*
 * Decompiled with CFR 0.152.
 */
package rsx.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class TcpClient {
    protected InetAddress adr;
    protected int port;
    protected Socket socket;
    protected int timeout = 0;
    protected BufferedReader input;
    protected PrintWriter output;

    public TcpClient(String ip, int port) throws UnknownHostException {
        this.adr = InetAddress.getByName(ip);
        this.port = port;
    }

    public TcpClient(InetAddress adr, int port) {
        this.adr = adr;
        this.port = port;
    }

    public void timeout(int second) {
        this.timeout = second * 1000;
    }

    public void notimeout() {
        this.timeout = 0;
    }

    public boolean connect() {
        try {
            this.socket = new Socket(this.adr, this.port);
            if (this.timeout > 0) {
                this.socket.setSoTimeout(this.timeout);
            }
            this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.output = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException ex) {
            System.err.println("Impossible de se connecter au serveur : " + ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean send(String msg) {
        this.output.print(msg);
        this.output.flush();
        return true;
    }

    public String receive() {
        try {
            return this.input.readLine();
        }
        catch (IOException ex) {
            if (!ex.getMessage().equals("Read timed out")) {
                System.err.println("Impossible de lire : " + ex.getMessage() + " ");
            }
            return null;
        }
    }

    public boolean close() {
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
        }
        catch (IOException ex) {
            System.err.println("Impossible de de fermer le client : " + ex.getMessage());
            return false;
        }
        return true;
    }

    public InetAddress getAdr() {
        return this.adr;
    }

    public void setAdr(InetAddress adr) {
        this.adr = adr;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

