/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.asm.tree.MethodNode;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;

public final class EnumFilter
implements IFilter {
    public void filter(String className, String superClassName, MethodNode methodNode, IFilterOutput output) {
        if (this.isMethodFiltered(className, superClassName, methodNode.name, methodNode.desc)) {
            output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
        }
    }

    private boolean isMethodFiltered(String className, String superClassName, String methodName, String methodDesc) {
        if ("java/lang/Enum".equals(superClassName)) {
            if ("values".equals(methodName) && ("()[L" + className + ";").equals(methodDesc)) {
                return true;
            }
            if ("valueOf".equals(methodName) && ("(Ljava/lang/String;)L" + className + ";").equals(methodDesc)) {
                return true;
            }
        }
        return false;
    }
}

