/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.pitest.mutationtest.commandline.MutationCoverageReport;
import org.pitest.mutationtest.config.ConfigOption;

public class PitestTask
extends Task {
    private static final String[] REQUIRED_OPTIONS = new String[]{ConfigOption.TARGET_CLASSES.getParamName(), ConfigOption.REPORT_DIR.getParamName(), ConfigOption.SOURCE_DIR.getParamName()};
    private final Map<String, String> options = new HashMap<String, String>();
    private String classpath;
    private String pitClasspath;

    public void execute() throws BuildException {
        try {
            this.execute(new Java((Task)this));
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    void execute(Java java) {
        this.setOption(ConfigOption.INCLUDE_LAUNCH_CLASSPATH, "false");
        this.setOption(ConfigOption.CLASSPATH, this.generateAnalysisClasspath());
        java.setClasspath(this.generateLaunchClasspath());
        java.setClassname(MutationCoverageReport.class.getCanonicalName());
        java.setFailonerror(true);
        java.setFork(true);
        this.checkRequiredOptions();
        for (Map.Entry<String, String> option : this.options.entrySet()) {
            java.createArg().setValue("--" + option.getKey() + "=" + option.getValue());
        }
        java.execute();
    }

    private Path generateLaunchClasspath() {
        if (this.pitClasspath == null) {
            throw new BuildException("You must specify the classpath for pitest and its plugins.");
        }
        Object reference = this.getProject().getReference(this.pitClasspath);
        if (reference != null) {
            this.pitClasspath = reference.toString();
        }
        return new Path(this.getProject(), this.pitClasspath);
    }

    private void checkRequiredOptions() {
        for (String requiredOption : REQUIRED_OPTIONS) {
            if (!this.optionMissing(requiredOption)) continue;
            throw new BuildException("You must specify the " + requiredOption + ".");
        }
    }

    private boolean optionMissing(String option) {
        return !this.options.keySet().contains(option);
    }

    private String generateAnalysisClasspath() {
        if (this.classpath == null) {
            throw new BuildException("You must specify the classpath.");
        }
        Object reference = this.getProject().getReference(this.classpath);
        if (reference != null) {
            this.classpath = reference.toString();
        }
        return this.classpath.replaceAll(File.pathSeparator, ",");
    }

    public void setReportDir(String value) {
        this.setOption(ConfigOption.REPORT_DIR, value);
    }

    public void setTargetClasses(String value) {
        this.setOption(ConfigOption.TARGET_CLASSES, value);
    }

    public void setTargetTests(String value) {
        this.setOption(ConfigOption.TEST_FILTER, value);
    }

    public void setDependencyDistance(String value) {
        this.setOption(ConfigOption.DEPENDENCY_DISTANCE, value);
    }

    public void setThreads(String value) {
        this.setOption(ConfigOption.THREADS, value);
    }

    public void setDetectInlinedCode(String value) {
        this.setOption(ConfigOption.USE_INLINED_CODE_DETECTION, value);
    }

    public void setTimestampedReports(String value) {
        this.setOption(ConfigOption.TIME_STAMPED_REPORTS, value);
    }

    public void setMutators(String value) {
        this.setOption(ConfigOption.MUTATIONS, value);
    }

    public void setFeatures(String value) {
        this.setOption(ConfigOption.FEATURES, value);
    }

    public void setExcludedMethods(String value) {
        this.setOption(ConfigOption.EXCLUDED_METHOD, value);
    }

    public void setExcludedClasses(String value) {
        this.setOption(ConfigOption.EXCLUDED_CLASSES, value);
    }

    public void setExcludedTestClasses(String value) {
        this.setOption(ConfigOption.EXCLUDED_TEST_CLASSES, value);
    }

    public void setAvoidCallsTo(String value) {
        this.setOption(ConfigOption.AVOID_CALLS, value);
    }

    public void setVerbose(String value) {
        this.setOption(ConfigOption.VERBOSE, value);
    }

    public void setTimeoutFactor(String value) {
        this.setOption(ConfigOption.TIMEOUT_FACTOR, value);
    }

    public void setTimeoutConst(String value) {
        this.setOption(ConfigOption.TIMEOUT_CONST, value);
    }

    public void setMaxMutationsPerClass(String value) {
        this.setOption(ConfigOption.MAX_MUTATIONS_PER_CLASS, value);
    }

    public void setJvmArgs(String value) {
        this.setOption(ConfigOption.CHILD_JVM, value);
    }

    public void setOutputFormats(String value) {
        this.setOption(ConfigOption.OUTPUT_FORMATS, value);
    }

    public void setSourceDir(String value) {
        this.setOption(ConfigOption.SOURCE_DIR, value);
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setPitClasspath(String classpath) {
        this.pitClasspath = classpath;
    }

    public void setMutableCodePaths(String glob) {
        this.setOption(ConfigOption.CODE_PATHS, glob);
    }

    public void setIncludedGroups(String value) {
        this.setOption(ConfigOption.INCLUDED_GROUPS, value);
    }

    public void setExcludedGroups(String value) {
        this.setOption(ConfigOption.EXCLUDED_GROUPS, value);
    }

    public void setIncludedTestMethods(String value) {
        this.setOption(ConfigOption.INCLUDED_TEST_METHODS, value);
    }

    public void setHistoryInputLocation(String value) {
        this.setOption(ConfigOption.HISTORY_INPUT_LOCATION, value);
    }

    public void setHistoryOutputLocation(String value) {
        this.setOption(ConfigOption.HISTORY_OUTPUT_LOCATION, value);
    }

    public void setMutationThreshold(String value) {
        this.setOption(ConfigOption.MUTATION_THRESHOLD, value);
    }

    public void setMaxSurviving(String value) {
        this.setOption(ConfigOption.MAX_SURVIVING, value);
    }

    public void setCoverageThreshold(String value) {
        this.setOption(ConfigOption.COVERAGE_THRESHOLD, value);
    }

    public void setMutationEngine(String value) {
        this.setOption(ConfigOption.MUTATION_ENGINE, value);
    }

    public void setJVM(String value) {
        this.setOption(ConfigOption.JVM_PATH, value);
    }

    private void setOption(ConfigOption option, String value) {
        if (!"".equals(value)) {
            this.options.put(option.getParamName(), value);
        }
    }

    public void setUseClasspathJar(String value) {
        this.setOption(ConfigOption.USE_CLASSPATH_JAR, value);
    }
}

