/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jbehave.core.io.PathCalculator;

public class RelativePathCalculator
implements PathCalculator {
    @Override
    public String calculate(String root, String path) {
        return this.join(this.calculatePath(this.split(root), this.split(path)));
    }

    private List<String> split(String path) {
        if (path.trim().length() == 0) {
            return new LinkedList<String>();
        }
        return new LinkedList<String>(Arrays.asList(path.replace('\\', '/').split("/")));
    }

    private Iterable<String> calculatePath(List<String> root, List<String> path) {
        if (path.get(0).length() == 0) {
            return path.subList(1, path.size());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (root.size() > 0) {
            list.addAll(root.subList(0, root.size() - 1));
        }
        list.addAll(path);
        return list;
    }

    private String join(Iterable<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String each : list) {
            sb.append("/").append(each);
        }
        return sb.substring(1);
    }
}

