/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import jsint.DynamicEnvironment;
import jsint.E;
import jsint.Import;
import jsint.JavaConstructor;
import jsint.JavaField;
import jsint.JavaMethod;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class DynamicVariable
implements Serializable {
    Symbol name;
    Object value = U.UNDEFINED;

    public DynamicVariable(Symbol name) {
        this.name = name;
    }

    public boolean isDefined() {
        return this.value != U.UNDEFINED;
    }

    public Object getDynamicValue() {
        Object value = this.value;
        if (value == U.UNDEFINED && (value = DynamicVariable.lookupJavaBinding(this.name)) != null) {
            this.value = value;
        }
        if (value == U.UNDEFINED) {
            return E.error("ERROR: undefined variable \"" + this.name + "\"");
        }
        if (value instanceof JavaField && ((JavaField)value).isStatic) {
            return ((JavaField)value).apply(U.NO_ARGS);
        }
        return value;
    }

    public Object setDynamicValue(Object newval) {
        Object tmpValue;
        Object existingValue = this.value;
        if (existingValue == U.UNDEFINED && (tmpValue = DynamicVariable.lookupJavaBinding(this.name)) != null) {
            this.value = tmpValue;
            existingValue = tmpValue;
        }
        if (existingValue instanceof JavaField && ((JavaField)existingValue).isStatic) {
            ((JavaField)existingValue).apply(new Object[]{newval});
        } else {
            this.value = newval;
        }
        return newval;
    }

    public String toString() {
        return this.name.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (Symbol)in.readObject();
        this.value = in.readObject();
    }

    private Object readResolve() throws ObjectStreamException {
        DynamicVariable it = Scheme.getInteractionEnvironment().intern(this.name);
        if (this.value != U.UNDEFINED) {
            it.value = this.value;
        }
        return it;
    }

    private static Object lookupJavaBinding(Symbol var) {
        String fullname;
        String name = fullname = var.toString();
        boolean canAccessPrivateData = false;
        if (fullname.endsWith("#")) {
            canAccessPrivateData = true;
            name = fullname.substring(0, name.length() - 1);
        }
        int firstIndex = name.indexOf(46);
        int lastIndex = name.lastIndexOf(46);
        int fieldIndex = name.lastIndexOf(36);
        int nameLength = name.length();
        Serializable value = U.UNDEFINED;
        if (firstIndex == -1) {
            return value;
        }
        try {
            if (fieldIndex == nameLength - 1) {
                value = firstIndex == 0 ? (lastIndex > 0 ? new JavaField(name.substring(lastIndex + 1, nameLength - 1), Import.classNamed(name.substring(1, lastIndex)), canAccessPrivateData) : new JavaField(name.substring(1, nameLength - 1), null, canAccessPrivateData)) : new JavaField(name.substring(lastIndex + 1, nameLength - 1), Import.classNamed(name.substring(0, lastIndex)), canAccessPrivateData);
            } else if (firstIndex == 0) {
                if (nameLength == 1) {
                    return var;
                }
                value = lastIndex > 0 ? new JavaMethod(name.substring(lastIndex + 1, nameLength), Import.classNamed(name.substring(1, lastIndex)), false, canAccessPrivateData) : new JavaMethod(name.substring(1, nameLength), null, false, canAccessPrivateData);
            } else {
                String methodName;
                value = lastIndex == nameLength - 1 ? new JavaConstructor(Import.classNamed(name.substring(0, lastIndex)).getName(), canAccessPrivateData) : ("class".equals(methodName = name.substring(lastIndex + 1, nameLength)) ? Import.classNamed(name.substring(0, lastIndex)) : new JavaMethod(name.substring(lastIndex + 1, nameLength), Import.classNamed(name.substring(0, lastIndex)), true, canAccessPrivateData));
            }
            return value;
        }
        catch (Exception e) {
            if (DynamicEnvironment.showJavaDotWarnings) {
                Scheme.currentEvaluator().getError().println("Javadot WARNING: " + e.getMessage());
            }
            return value;
        }
    }
}

