/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.NameCachingRoot;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;

public class CompoundClassPathRoot
implements ClassPathRoot,
Iterable<ClassPathRoot> {
    private final List<ClassPathRoot> roots = new ArrayList<ClassPathRoot>();

    public CompoundClassPathRoot(List<ClassPathRoot> roots) {
        this.roots.addAll(CompoundClassPathRoot.wrapToAvoidIOOperations(roots));
    }

    @Override
    public InputStream getData(String name) throws IOException {
        for (ClassPathRoot each : this.roots) {
            InputStream is = each.getData(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Collection<String> classNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClassPathRoot root : this.roots) {
            arrayList.addAll(root.classNames());
        }
        return arrayList;
    }

    @Override
    public URL getResource(String name) throws MalformedURLException {
        try {
            return this.findRootForResource(name);
        }
        catch (IOException exception) {
            return null;
        }
    }

    private URL findRootForResource(String name) throws IOException {
        for (ClassPathRoot root : this.roots) {
            URL u = root.getResource(name);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    @Override
    public Option<String> cacheLocation() {
        StringBuilder classpath = new StringBuilder();
        for (ClassPathRoot each : this.roots) {
            Option<String> additional = each.cacheLocation();
            for (String path : additional) {
                classpath = classpath.append(File.pathSeparator + path);
            }
        }
        return Option.some(classpath.toString());
    }

    @Override
    public Iterator<ClassPathRoot> iterator() {
        return this.roots.iterator();
    }

    private static List<ClassPathRoot> wrapToAvoidIOOperations(List<ClassPathRoot> roots) {
        return FCollection.map(roots, NameCachingRoot.toCachingRoot());
    }
}

