/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.IOHeavyRoot;
import org.pitest.functional.F;
import org.pitest.functional.Option;

public class NameCachingRoot
implements ClassPathRoot {
    private final ClassPathRoot child;
    private SoftReference<Collection<String>> cache;

    public NameCachingRoot(ClassPathRoot child) {
        this.child = child;
    }

    @Override
    public URL getResource(String name) throws MalformedURLException {
        return this.child.getResource(name);
    }

    @Override
    public InputStream getData(String name) throws IOException {
        Collection<String> names = this.classNames();
        if (!names.contains(ClassName.fromString(name).asJavaName())) {
            return null;
        }
        return this.child.getData(name);
    }

    @Override
    public Collection<String> classNames() {
        Collection<String> cachedNames;
        if (this.cache != null && (cachedNames = this.cache.get()) != null) {
            return cachedNames;
        }
        Collection<String> names = this.child.classNames();
        this.cache = new SoftReference<Collection<String>>(names);
        return names;
    }

    @Override
    public Option<String> cacheLocation() {
        return this.child.cacheLocation();
    }

    public static F<ClassPathRoot, ClassPathRoot> toCachingRoot() {
        return new F<ClassPathRoot, ClassPathRoot>(){

            @Override
            public ClassPathRoot apply(ClassPathRoot a) {
                if (a instanceof IOHeavyRoot) {
                    return new NameCachingRoot(a);
                }
                return a;
            }
        };
    }
}

