/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.mocksupport;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.pitest.bytecode.FrameOptions;
import org.pitest.functional.F;
import org.pitest.functional.predicate.Predicate;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.ClassWriter;

public class BendJavassistToMyWillTransformer
implements ClassFileTransformer {
    private final Predicate<String> filter;
    private final F<ClassWriter, ClassVisitor> transformation;

    public BendJavassistToMyWillTransformer(Predicate<String> filter, F<ClassWriter, ClassVisitor> transformation) {
        this.filter = filter;
        this.transformation = transformation;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.shouldInclude(className)) {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(FrameOptions.pickFlags(classfileBuffer));
            reader.accept(this.transformation.apply(writer), 8);
            return writer.toByteArray();
        }
        return null;
    }

    private boolean shouldInclude(String className) {
        return (Boolean)this.filter.apply(className);
    }
}

