/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log {
    private static final Logger LOGGER = Logger.getLogger("PIT");

    public static Logger getLogger() {
        return LOGGER;
    }

    private static void addOrSetHandler(Handler handler) {
        if (LOGGER.getHandlers().length == 0) {
            LOGGER.addHandler(handler);
        } else {
            Log.LOGGER.getHandlers()[0] = handler;
        }
    }

    public static void setVerbose(boolean on) {
        if (on) {
            Log.setLevel(Level.FINEST);
        } else {
            Log.setLevel(Level.INFO);
        }
    }

    private static void setLevel(Level level) {
        LOGGER.setLevel(level);
        for (Handler each : LOGGER.getHandlers()) {
            each.setLevel(level);
        }
    }

    public static boolean isVerbose() {
        return Level.FINEST.equals(LOGGER.getLevel());
    }

    static {
        if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
            LOGGER.setUseParentHandlers(false);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(new PlainFormatter());
            Log.addOrSetHandler(handler);
            LOGGER.setLevel(Level.INFO);
            handler.setLevel(Level.ALL);
        }
    }

    static class PlainFormatter
    extends Formatter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final DateFormat dateFormat = DateFormat.getTimeInstance();

        PlainFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder buf = new StringBuilder(180);
            buf.append(this.dateFormat.format(new Date(record.getMillis())));
            buf.append(" PIT >> ");
            buf.append(record.getLevel());
            buf.append(" : ");
            buf.append(this.formatMessage(record));
            buf.append(LINE_SEPARATOR);
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                StringWriter sink = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)sink, true));
                buf.append(sink.toString());
            }
            return buf.toString();
        }
    }
}

