/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.pitest.util.Unchecked;

public class SafeDataInputStream {
    private final DataInputStream dis;

    public SafeDataInputStream(InputStream is) {
        this.dis = new DataInputStream(is);
    }

    public int readInt() {
        try {
            return this.dis.readInt();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public String readString() {
        try {
            return new String(this.readBytes(), "UTF-8");
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public byte[] readBytes() {
        try {
            int length = this.dis.readInt();
            byte[] data = new byte[length];
            this.dis.readFully(data);
            return data;
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public <T extends Serializable> T read(Class<T> type) {
        try {
            return (T)((Serializable)this.deserialize(this.readBytes()));
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public void close() {
        try {
            this.dis.close();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public byte readByte() {
        try {
            return this.dis.readByte();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public boolean readBoolean() {
        try {
            return this.dis.readBoolean();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    public long readLong() {
        try {
            return this.dis.readLong();
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException(e);
        }
    }

    private Object deserialize(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try (ObjectInputStream in = null;){
            in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return object;
        }
    }
}

