/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalIterable;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.SideEffect1;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.MutationGrouping;

public class MutationResultList
implements FunctionalIterable<MutationResult> {
    private final List<MutationResult> impl = new ArrayList<MutationResult>();

    public MutationResultList(Collection<MutationResult> results) {
        this.impl.addAll(results);
    }

    public List<MutationGrouping> groupMutationsByLine() {
        this.sortMutationsIntoLineOrder();
        ArrayList<MutationGrouping> groups = new ArrayList<MutationGrouping>();
        ArrayList<Object> sublist = new ArrayList<MutationResult>();
        int lastLineNumber = -1;
        for (MutationResult each : this.impl) {
            if (lastLineNumber != each.getDetails().getLineNumber() && !sublist.isEmpty()) {
                groups.add(new MutationGrouping(lastLineNumber, "Line " + lastLineNumber, sublist));
                sublist = new ArrayList();
            }
            sublist.add(each);
            lastLineNumber = each.getDetails().getLineNumber();
        }
        if (!sublist.isEmpty()) {
            groups.add(new MutationGrouping(lastLineNumber, "Line " + lastLineNumber, sublist));
        }
        return groups;
    }

    private void sortMutationsIntoLineOrder() {
        Comparator<MutationResult> c = new Comparator<MutationResult>(){

            @Override
            public int compare(MutationResult o1, MutationResult o2) {
                return o1.getDetails().getLineNumber() - o2.getDetails().getLineNumber();
            }
        };
        Collections.sort(this.impl, c);
    }

    public boolean contains(F<MutationResult, Boolean> predicate) {
        return FCollection.contains(this.impl, predicate);
    }

    public FunctionalList<MutationResult> filter(F<MutationResult, Boolean> predicate) {
        return FCollection.filter((Iterable)((Object)this), predicate);
    }

    public <B> FunctionalList<B> flatMap(F<MutationResult, ? extends Iterable<B>> f) {
        return FCollection.flatMap((Iterable)((Object)this), f);
    }

    public void forEach(SideEffect1<MutationResult> e) {
        FCollection.forEach((Iterable)((Object)this), e);
    }

    public Iterator<MutationResult> iterator() {
        return this.impl.iterator();
    }

    public <B> FunctionalList<B> map(F<MutationResult, B> f) {
        return FCollection.map((Iterable)((Object)this), f);
    }

    public <B> void mapTo(F<MutationResult, B> f, Collection<? super B> bs) {
        FCollection.mapTo((Iterable)((Object)this), f, bs);
    }
}

