/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.Alias;
import org.jbehave.core.annotations.Aliases;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Composite;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.PatternVariantBuilder;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepCreator;
import org.jbehave.core.steps.StepType;

public class Steps
implements CandidateSteps {
    private final Configuration configuration;
    private Class<?> type;
    private InjectableStepsFactory stepsFactory;

    public Steps() {
        this(new MostUsefulConfiguration());
    }

    public Steps(Configuration configuration) {
        this.configuration = configuration;
        this.type = this.getClass();
        this.stepsFactory = new InstanceStepsFactory(configuration, this);
    }

    public Steps(Configuration configuration, Object instance) {
        this.configuration = configuration;
        this.type = instance.getClass();
        this.stepsFactory = new InstanceStepsFactory(configuration, instance);
    }

    public Steps(Configuration configuration, Class<?> type, InjectableStepsFactory stepsFactory) {
        this.configuration = configuration;
        this.type = type;
        this.stepsFactory = stepsFactory;
    }

    public Class<?> type() {
        return this.type;
    }

    public Object instance() {
        return this.stepsFactory.createInstanceOfType(this.type);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public List<StepCandidate> listCandidates() {
        ArrayList<StepCandidate> candidates = new ArrayList<StepCandidate>();
        for (Method method : this.allMethods()) {
            int priority;
            String value;
            Annotation annotation;
            if (method.isAnnotationPresent(Given.class)) {
                annotation = method.getAnnotation(Given.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.GIVEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.GIVEN, priority);
            }
            if (method.isAnnotationPresent(When.class)) {
                annotation = method.getAnnotation(When.class);
                value = annotation.value();
                priority = annotation.priority();
                this.addCandidatesFromVariants(candidates, method, StepType.WHEN, value, priority);
                this.addCandidatesFromAliases(candidates, method, StepType.WHEN, priority);
            }
            if (!method.isAnnotationPresent(Then.class)) continue;
            annotation = method.getAnnotation(Then.class);
            value = annotation.value();
            priority = annotation.priority();
            this.addCandidatesFromVariants(candidates, method, StepType.THEN, value, priority);
            this.addCandidatesFromAliases(candidates, method, StepType.THEN, priority);
        }
        return candidates;
    }

    private void addCandidatesFromVariants(List<StepCandidate> candidates, Method method, StepType stepType, String value, int priority) {
        PatternVariantBuilder b = new PatternVariantBuilder(value);
        for (String variant : b.allVariants()) {
            this.addCandidate(candidates, method, stepType, variant, priority);
        }
    }

    private void addCandidatesFromAliases(List<StepCandidate> candidates, Method method, StepType stepType, int priority) {
        if (method.isAnnotationPresent(Aliases.class)) {
            String[] aliases;
            for (String alias : aliases = method.getAnnotation(Aliases.class).values()) {
                this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
            }
        }
        if (method.isAnnotationPresent(Alias.class)) {
            String alias = method.getAnnotation(Alias.class).value();
            this.addCandidatesFromVariants(candidates, method, stepType, alias, priority);
        }
    }

    private void addCandidate(List<StepCandidate> candidates, Method method, StepType stepType, String stepPatternAsString, int priority) {
        this.checkForDuplicateCandidates(candidates, stepType, stepPatternAsString);
        StepCandidate candidate = this.createCandidate(method, stepType, stepPatternAsString, priority, this.configuration);
        candidate.useStepMonitor(this.configuration.stepMonitor());
        candidate.useParanamer(this.configuration.paranamer());
        candidate.doDryRun(this.configuration.storyControls().dryRun());
        if (method.isAnnotationPresent(Composite.class)) {
            candidate.composedOf(method.getAnnotation(Composite.class).steps());
        }
        candidates.add(candidate);
    }

    private void checkForDuplicateCandidates(List<StepCandidate> candidates, StepType stepType, String patternAsString) {
        for (StepCandidate candidate : candidates) {
            if (candidate.getStepType() != stepType || !candidate.getPatternAsString().equals(patternAsString)) continue;
            throw new DuplicateCandidateFound(stepType, patternAsString);
        }
    }

    private StepCandidate createCandidate(Method method, StepType stepType, String stepPatternAsString, int priority, Configuration configuration) {
        return new StepCandidate(stepPatternAsString, priority, stepType, method, this.type, this.stepsFactory, configuration.stepsContext(), configuration.keywords(), configuration.stepPatternParser(), configuration.parameterConverters(), configuration.parameterControls());
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStories() {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.stepsHaving(StepCollector.Stage.BEFORE, BeforeStories.class));
        steps.addAll(this.stepsHaving(StepCollector.Stage.AFTER, AfterStories.class));
        return steps;
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterStory(boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.stepsHaving(StepCollector.Stage.BEFORE, BeforeStory.class, givenStory));
        steps.addAll(this.stepsHaving(StepCollector.Stage.AFTER, AfterStory.class, givenStory));
        return steps;
    }

    @Override
    public List<BeforeOrAfterStep> listBeforeOrAfterScenario(ScenarioType type) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        steps.addAll(this.scenarioStepsHaving(type, StepCollector.Stage.BEFORE, BeforeScenario.class, new AfterScenario.Outcome[0]));
        steps.addAll(this.scenarioStepsHaving(type, StepCollector.Stage.AFTER, AfterScenario.class, AfterScenario.Outcome.ANY, AfterScenario.Outcome.SUCCESS, AfterScenario.Outcome.FAILURE));
        return steps;
    }

    private boolean runnableStoryStep(Annotation annotation, boolean givenStory) {
        boolean uponGivenStory = this.uponGivenStory(annotation);
        return uponGivenStory == givenStory;
    }

    private boolean uponGivenStory(Annotation annotation) {
        if (annotation instanceof BeforeStory) {
            return ((BeforeStory)annotation).uponGivenStory();
        }
        if (annotation instanceof AfterStory) {
            return ((AfterStory)annotation).uponGivenStory();
        }
        return false;
    }

    private List<BeforeOrAfterStep> stepsHaving(StepCollector.Stage stage, Class<? extends Annotation> annotationClass) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : this.methodsAnnotatedWith(annotationClass)) {
            steps.add(this.createBeforeOrAfterStep(stage, method));
        }
        return steps;
    }

    private List<BeforeOrAfterStep> stepsHaving(StepCollector.Stage stage, Class<? extends Annotation> annotationClass, boolean givenStory) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : this.methodsAnnotatedWith(annotationClass)) {
            if (!this.runnableStoryStep(method.getAnnotation(annotationClass), givenStory)) continue;
            steps.add(this.createBeforeOrAfterStep(stage, method));
        }
        return steps;
    }

    private List<BeforeOrAfterStep> scenarioStepsHaving(ScenarioType type, StepCollector.Stage stage, Class<? extends Annotation> annotationClass, AfterScenario.Outcome ... outcomes) {
        ArrayList<BeforeOrAfterStep> steps = new ArrayList<BeforeOrAfterStep>();
        for (Method method : this.methodsAnnotatedWith(annotationClass)) {
            ScenarioType scenarioType = this.scenarioType(method, annotationClass);
            if (type != scenarioType) continue;
            if (stage == StepCollector.Stage.BEFORE) {
                steps.add(this.createBeforeOrAfterStep(stage, method));
            }
            if (stage != StepCollector.Stage.AFTER) continue;
            AfterScenario.Outcome scenarioOutcome = this.scenarioOutcome(method, annotationClass);
            for (AfterScenario.Outcome outcome : outcomes) {
                if (!outcome.equals((Object)scenarioOutcome)) continue;
                steps.add(this.createBeforeOrAfterStep(stage, method, outcome));
            }
        }
        return steps;
    }

    private ScenarioType scenarioType(Method method, Class<? extends Annotation> annotationClass) {
        if (annotationClass.isAssignableFrom(BeforeScenario.class)) {
            return ((BeforeScenario)method.getAnnotation(annotationClass)).uponType();
        }
        if (annotationClass.isAssignableFrom(AfterScenario.class)) {
            return ((AfterScenario)method.getAnnotation(annotationClass)).uponType();
        }
        return ScenarioType.NORMAL;
    }

    private AfterScenario.Outcome scenarioOutcome(Method method, Class<? extends Annotation> annotationClass) {
        if (annotationClass.isAssignableFrom(AfterScenario.class)) {
            return ((AfterScenario)method.getAnnotation(annotationClass)).uponOutcome();
        }
        return AfterScenario.Outcome.ANY;
    }

    private BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method) {
        return this.createBeforeOrAfterStep(stage, method, AfterScenario.Outcome.ANY);
    }

    private BeforeOrAfterStep createBeforeOrAfterStep(StepCollector.Stage stage, Method method, AfterScenario.Outcome outcome) {
        return new BeforeOrAfterStep(stage, method, outcome, new StepCreator(this.type, this.stepsFactory, this.configuration.stepsContext(), this.configuration.parameterConverters(), this.configuration.parameterControls(), null, this.configuration.stepMonitor()));
    }

    private List<Method> allMethods() {
        return Arrays.asList(this.type.getMethods());
    }

    private List<Method> methodsAnnotatedWith(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> annotated = new ArrayList<Method>();
        for (Method method : this.allMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotated.add(method);
        }
        return annotated;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.instance()).toString();
    }

    public static class DuplicateCandidateFound
    extends RuntimeException {
        public DuplicateCandidateFound(StepType stepType, String patternAsString) {
            super((Object)((Object)stepType) + " " + patternAsString);
        }
    }
}

