/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import jsint.E;
import jsint.LexicalEnvironment;
import jsint.Pair;
import jsint.Procedure;
import jsint.Scheme;
import jsint.U;

public class Closure
extends Procedure
implements Cloneable {
    Object body;
    LexicalEnvironment lexenv;
    Object parms;

    public Closure(Object parms, Object body, LexicalEnvironment lexenv) {
        this.parms = parms;
        this.body = body;
        this.lexenv = lexenv;
        this.computeArgs(parms, 0);
    }

    private void computeArgs(Object parms, int min) {
        if (U.isPair(parms)) {
            this.computeArgs(((Pair)parms).rest, min + 1);
        } else if (parms == Pair.EMPTY) {
            this.minArgs = min;
            this.maxArgs = min;
        } else {
            this.minArgs = min;
            this.maxArgs = Integer.MAX_VALUE;
        }
    }

    public Object apply(Object[] args) {
        return Scheme.currentEvaluator().execute(this.body, new LexicalEnvironment(this.parms, args, this.lexenv));
    }

    public Closure copy(LexicalEnvironment lexenv) {
        Closure c = null;
        try {
            c = (Closure)this.clone();
        }
        catch (CloneNotSupportedException e) {
            E.error("internal error: no clone");
        }
        c.lexenv = lexenv;
        return c;
    }

    public String toString() {
        return "(lambda " + this.name + " " + U.stringify(this.parms) + "...)";
    }

    public Object setName(Object name) {
        super.setName(name);
        Closure.identifyInternalClosures(name.toString(), 0, this.body);
        return name;
    }

    private static int identifyInternalClosures(String name, int count, Object body) {
        if (body instanceof Closure) {
            Closure c = (Closure)body;
            if (c.name == "??") {
                c.name = name + "~" + count++;
            }
            return Closure.identifyInternalClosures(name, count, c.body);
        }
        if (body instanceof Object[]) {
            Object[] exp = (Object[])body;
            for (int i = 0; i < exp.length; ++i) {
                count = Closure.identifyInternalClosures(name, count, exp[i]);
            }
            return count;
        }
        return count;
    }
}

