/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import jsint.DynamicVariable;
import jsint.E;
import jsint.Macro;
import jsint.Pair;
import jsint.Symbol;

public class DynamicEnvironment
implements Serializable {
    public static boolean showJavaDotWarnings = false;
    private boolean lockedDown = false;
    protected Hashtable rep;

    public DynamicEnvironment() {
        this.rep = new Hashtable(100);
    }

    public DynamicEnvironment(DynamicEnvironment baseEnv) {
        this.rep = new Hashtable(baseEnv.rep.size() + 100);
        Enumeration keys = baseEnv.rep.keys();
        while (keys.hasMoreElements()) {
            Object k = keys.nextElement();
            this.rep.put(k, baseEnv.rep.get(k));
        }
    }

    public void lockDown() {
        this.lockedDown = true;
    }

    public static Pair getBindings(Object x) {
        if (!(x instanceof DynamicEnvironment)) {
            E.error("ERROR: not an environment: " + x.toString());
            return null;
        }
        Pair bindings = Pair.EMPTY;
        DynamicEnvironment env = (DynamicEnvironment)x;
        Enumeration keys = env.rep.keys();
        while (keys.hasMoreElements()) {
            Symbol k = (Symbol)keys.nextElement();
            if (DynamicEnvironment.isJavaLiteral(k) || !env.isDefined(k)) continue;
            Object v = env.getValue(k);
            bindings = new Pair(new Pair(k, v), bindings);
        }
        return bindings;
    }

    private static boolean isJavaLiteral(Symbol name) {
        return name.toString().indexOf(46) != -1;
    }

    public void importBindings(DynamicEnvironment env, String prefix) {
        this.importBindings(env, prefix, false);
    }

    public void importBindings(DynamicEnvironment env, String prefix, boolean importMacros) {
        this.importBindings(env, prefix, importMacros, null);
    }

    public void importBindings(DynamicEnvironment env, String prefix, boolean importMacros, Symbol[] procnames) {
        HashSet<Symbol> hs = null;
        if (procnames != null) {
            hs = new HashSet<Symbol>(Arrays.asList(procnames));
        }
        if (this.lockedDown) {
            E.error("ERROR: attempting to import bindings into locked environment");
        } else {
            Enumeration keys = env.rep.keys();
            while (keys.hasMoreElements()) {
                Object v;
                Symbol k = (Symbol)keys.nextElement();
                if (!env.isDefined(k) || DynamicEnvironment.isJavaLiteral(k) || importMacros != (v = env.getValue(k)) instanceof Macro || hs != null && !hs.contains(k)) continue;
                Symbol newk = prefix != null ? Symbol.intern(prefix + k.toString()) : k;
                this.setValue(newk, v);
            }
        }
    }

    public Object getValue(Symbol s) {
        return this.intern(s).getDynamicValue();
    }

    public boolean isDefined(Symbol s) {
        DynamicVariable it = (DynamicVariable)this.rep.get(s);
        return it != null && it.isDefined();
    }

    public Object setValue(Symbol s, Object newval) {
        if (this.lockedDown) {
            return E.error("ERROR: attempting to alter bindings in locked environment:" + s.toString() + " <-- " + newval.toString());
        }
        return this.intern(s).setDynamicValue(newval);
    }

    public DynamicVariable intern(Symbol x) {
        DynamicVariable it = (DynamicVariable)this.rep.get(x);
        if (it == null) {
            it = new DynamicVariable(x);
            this.rep.put(x, it);
        }
        return it;
    }
}

