/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.Serializable;
import jscheme.SchemePair;
import jscheme.SchemeProcedure;
import jsint.BacktraceException;
import jsint.E;
import jsint.Evaluator;
import jsint.JschemeThrowable;
import jsint.LexicalEnvironment;
import jsint.Pair;
import jsint.U;

public abstract class Procedure
implements Runnable,
Serializable,
SchemeProcedure {
    public String name = "??";
    public int minArgs = 0;
    public int maxArgs = Integer.MAX_VALUE;

    public Procedure() {
    }

    public Procedure(int minArgs, int maxArgs) {
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    public String getName() {
        return this.name;
    }

    public Object setName(Object name) {
        if (this.name == "??") {
            this.name = name.toString();
        }
        return name;
    }

    public int nParms() {
        return this.minArgs == this.maxArgs ? this.minArgs : this.minArgs + 1;
    }

    protected String toStringArgs() {
        if (this.minArgs == this.maxArgs) {
            return "[" + this.minArgs + "]";
        }
        return "[" + this.minArgs + "," + (this.maxArgs == Integer.MAX_VALUE ? "n" : String.valueOf(this.maxArgs)) + "]";
    }

    public String toString() {
        return "{" + this.getClass().getName() + " " + this.name + this.toStringArgs() + "}";
    }

    public void run() {
        if (this.minArgs == 0) {
            this.apply(Pair.EMPTY);
        } else {
            E.error("This procedure can't be run()", this);
        }
    }

    public abstract Object apply(Object[] var1);

    public Object apply(SchemePair args) {
        return this.apply(this.makeArgArray((Pair)args));
    }

    public Object apply(Pair args) {
        return this.apply(this.makeArgArray(args));
    }

    public static Object catching(Procedure E2, Procedure F) {
        try {
            return E2.apply(Pair.EMPTY);
        }
        catch (Throwable e) {
            return F.apply(new Pair(e, Pair.EMPTY));
        }
    }

    public static Object tryCatch(Object E2, Object F) {
        try {
            return ((Procedure)E2).apply(Pair.EMPTY);
        }
        catch (Throwable e) {
            return ((Procedure)F).apply(new Pair(Procedure.stripExceptionWrapper(e), Pair.EMPTY));
        }
    }

    public static Object stripExceptionWrapper(Object e) {
        if (e instanceof BacktraceException) {
            return Procedure.stripExceptionWrapper(((BacktraceException)e).getBaseException());
        }
        if (e instanceof JschemeThrowable) {
            return Procedure.stripExceptionWrapper(((JschemeThrowable)e).contents);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object tryFinally(Object e, Object f) {
        try {
            Object object = ((Procedure)e).apply(Pair.EMPTY);
            return object;
        }
        finally {
            ((Procedure)f).apply(Pair.EMPTY);
        }
    }

    public static Object throwRuntimeException(RuntimeException E2) throws RuntimeException {
        throw E2;
    }

    public static Object throwObject(Object e) throws Throwable {
        if (e instanceof Throwable) {
            throw (Throwable)e;
        }
        return E.error("can't throw object " + e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object synchronize(Object x, Procedure p) {
        Object object = x;
        synchronized (object) {
            return p.apply(new Pair(x, Pair.EMPTY));
        }
    }

    public Object[] makeArgArray(Object[] code, Evaluator eval, LexicalEnvironment lexenv) {
        Procedure p = this;
        Object[] argArray = new Object[p.nParms()];
        int nargs = code.length - 1;
        int pminargs = p.minArgs;
        if (nargs < pminargs) {
            E.error("\nToo few arguments to procedure " + p.name + " expected at least " + pminargs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(code) + "\n************\n");
        }
        if (nargs > p.maxArgs) {
            E.error("\nToo many arguments to procedure " + p.name + " expected at most " + p.maxArgs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(code) + "\n************\n");
        }
        for (int i = 0; i < pminargs; ++i) {
            argArray[i] = eval.execute(code[i + 1], lexenv);
        }
        if (p.maxArgs > pminargs) {
            if (p.maxArgs == pminargs + 1) {
                argArray[pminargs] = code.length > p.maxArgs ? eval.execute(code[pminargs + 1], lexenv) : U.MISSING;
            } else {
                Pair tail = Pair.EMPTY;
                for (int i = nargs; i > pminargs; --i) {
                    tail = new Pair(eval.execute(code[i], lexenv), tail);
                }
                argArray[pminargs] = tail;
            }
        }
        return argArray;
    }

    public Object[] makeArgArray(Pair args) {
        Procedure p = this;
        Object[] argArray = new Object[p.nParms()];
        int nargs = args.length();
        if (nargs < p.minArgs) {
            E.error("\nToo few arguments to procedure " + p.name + " expected at least " + p.minArgs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(args) + "\n************\n");
        }
        if (nargs > p.maxArgs) {
            E.error("\nToo many arguments to procedure " + p.name + " expected at most " + p.maxArgs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(args) + "\n************\n");
        }
        for (int i = 0; i < p.minArgs; ++i) {
            argArray[i] = args.first;
            args = U.toList(args.rest);
        }
        if (p.maxArgs > p.minArgs) {
            argArray[p.minArgs] = p.maxArgs == p.minArgs + 1 ? (U.isPair(args) ? args.first : U.MISSING) : args;
        }
        return argArray;
    }
}

