/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.commandline;

import java.util.HashMap;
import org.pitest.coverage.CoverageSummary;
import org.pitest.mutationtest.commandline.OptionsParser;
import org.pitest.mutationtest.commandline.ParseResult;
import org.pitest.mutationtest.commandline.PluginFilter;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.tooling.AnalysisResult;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.mutationtest.tooling.EntryPoint;
import org.pitest.util.Unchecked;

public class MutationCoverageReport {
    public static void main(String[] args) {
        PluginServices plugins = PluginServices.makeForContextLoader();
        OptionsParser parser = new OptionsParser(new PluginFilter(plugins));
        ParseResult pr = parser.parse(args);
        if (!pr.isOk()) {
            parser.printHelp();
            System.out.println(">>>> " + (String)pr.getErrorMessage().value());
        } else {
            ReportOptions data = pr.getOptions();
            CombinedStatistics stats = MutationCoverageReport.runReport(data, plugins);
            MutationCoverageReport.throwErrorIfScoreBelowCoverageThreshold(stats.getCoverageSummary(), data.getCoverageThreshold());
            MutationCoverageReport.throwErrorIfScoreBelowMutationThreshold(stats.getMutationStatistics(), data.getMutationThreshold());
            MutationCoverageReport.throwErrorIfMoreThanMaxSuvivingMutants(stats.getMutationStatistics(), data.getMaximumAllowedSurvivors());
        }
    }

    private static void throwErrorIfScoreBelowCoverageThreshold(CoverageSummary stats, int threshold) {
        if (threshold != 0 && stats.getCoverage() < threshold) {
            throw new RuntimeException("Line coverage of " + stats.getCoverage() + " is below threshold of " + threshold);
        }
    }

    private static void throwErrorIfScoreBelowMutationThreshold(MutationStatistics stats, int threshold) {
        if (threshold != 0 && stats.getPercentageDetected() < (long)threshold) {
            throw new RuntimeException("Mutation score of " + stats.getPercentageDetected() + " is below threshold of " + threshold);
        }
    }

    private static void throwErrorIfMoreThanMaxSuvivingMutants(MutationStatistics stats, long threshold) {
        if (threshold > 0L && stats.getTotalSurvivingMutations() > threshold) {
            throw new RuntimeException("Had " + stats.getTotalSurvivingMutations() + " surviving mutants, but only " + threshold + " survivors allowed");
        }
    }

    private static CombinedStatistics runReport(ReportOptions data, PluginServices plugins) {
        EntryPoint e = new EntryPoint();
        AnalysisResult result = e.execute(null, data, plugins, new HashMap());
        if (result.getError().hasSome()) {
            throw Unchecked.translateCheckedException((Throwable)((Throwable)result.getError().value()));
        }
        return (CombinedStatistics)result.getStatistics().value();
    }
}

