/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;

public class EqualsPerformanceShortcutFilter
implements MutationInterceptor {
    private static final boolean DEBUG = false;
    private static final Match<AbstractInsnNode> IGNORE = InstructionMatchers.isA(LineNumberNode.class).or(InstructionMatchers.isA(FrameNode.class));
    static final SequenceMatcher<AbstractInsnNode> ALWAYS_FALSE = QueryStart.any(AbstractInsnNode.class).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(25)).then(InstructionMatchers.opCode(88)).then(InstructionMatchers.opCode(167).and(InstructionMatchers.debug("goto"))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(IGNORE).withDebug(false));
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        FunctionalList doNotTouch = FCollection.filter(mutations, (F)Prelude.not(this.inEqualsMethod()));
        if (doNotTouch.size() != mutations.size()) {
            FunctionalList inEquals = FCollection.filter(mutations, this.inEqualsMethod());
            List<MutationDetails> filtered = this.filter((FunctionalList<MutationDetails>)inEquals, m);
            doNotTouch.addAll(filtered);
        }
        return doNotTouch;
    }

    private List<MutationDetails> filter(FunctionalList<MutationDetails> inEquals, Mutater m) {
        Location equalsMethod = ((MutationDetails)inEquals.get(0)).getId().getLocation();
        Option maybeEquals = this.currentClass.methods().findFirst(MethodMatchers.forLocation(equalsMethod));
        return inEquals.filter((F)Prelude.not(this.isShortcutEquals((MethodTree)maybeEquals.value(), m)));
    }

    private F<MutationDetails, Boolean> isShortcutEquals(final MethodTree tree, final Mutater m) {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                return EqualsPerformanceShortcutFilter.this.shortCutEquals(tree, a, m);
            }
        };
    }

    private Boolean shortCutEquals(MethodTree tree, MutationDetails a, Mutater m) {
        if (!this.mutatesAConditionalJump(tree, a.getInstructionIndex())) {
            return false;
        }
        ClassTree mutant = ClassTree.fromBytes(m.getMutation(a.getId()).getBytes());
        MethodTree mutantEquals = (MethodTree)mutant.methods().findFirst(MethodMatchers.forLocation(tree.asLocation())).value();
        return ALWAYS_FALSE.matches(mutantEquals.instructions());
    }

    private boolean mutatesAConditionalJump(MethodTree tree, int index) {
        AbstractInsnNode mutatedInsns = (AbstractInsnNode)tree.instructions().get(index);
        return InstructionMatchers.aConditionalJump().test(null, (Object)mutatedInsns);
    }

    private F<MutationDetails, Boolean> inEqualsMethod() {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                Location loc = a.getId().getLocation();
                return loc.getMethodDesc().equals("(Ljava/lang/Object;)Z") && loc.getMethodName().equals((Object)MethodName.fromString((String)"equals"));
            }
        };
    }

    @Override
    public void end() {
    }
}

