/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import jscheme.JScheme;
import jsint.BacktraceException;
import jsint.LocalVariable;
import jsint.Pair;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class LexicalEnvironment
implements Serializable {
    public static final LexicalEnvironment NULLENV = new LexicalEnvironment(Pair.EMPTY, null, null, true);
    private LexicalEnvironment parent;
    private Object vars;
    private Object[] vals;
    private boolean isNullEnv = false;

    public LexicalEnvironment(Object vars, Object[] vals, LexicalEnvironment parent) {
        this(vars, vals, parent, false);
    }

    public LexicalEnvironment(Object vars, Object[] vals, LexicalEnvironment parent, boolean isNullEnv) {
        this.vars = vars;
        this.vals = vals;
        this.parent = parent;
        this.isNullEnv = isNullEnv;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.isNullEnv ? NULLENV : this;
    }

    public LocalVariable lookup(Symbol var) {
        return this.lookup(var, 0, 0, this.vars);
    }

    public LocalVariable lookup(Symbol var, int up, int in, Object vars) {
        if (this == NULLENV) {
            return null;
        }
        if (vars == var) {
            return new LocalVariable(up, in, var);
        }
        if (!U.isPair(vars)) {
            return this.parent.lookup(var, up + 1, 0, this.parent.vars);
        }
        if (U.first(vars) == var) {
            return new LocalVariable(up, in, var);
        }
        return this.lookup(var, up, in + 1, U.rest(vars));
    }

    public Object get(LocalVariable var) {
        return this.up((int)var.up).vals[var.in];
    }

    public Object set(LocalVariable var, Object newVal) {
        this.up((int)var.up).vals[var.in] = newVal;
        return this.up((int)var.up).vals[var.in];
    }

    LexicalEnvironment up(int levels) {
        return levels == 0 ? this : this.parent.up(levels - 1);
    }

    public String toString() {
        return "{|" + this.toString0() + "|}";
    }

    private String toString0() {
        if (this == NULLENV) {
            return "";
        }
        return U.stringify(this.vars) + " " + U.stringify(this.vals) + (this.parent == null ? "" : "|" + this.parent.toString0());
    }

    public void show(PrintWriter s) {
        LexicalEnvironment e = this;
        while (e != NULLENV) {
            Object vars = e.vars;
            Object[] vals = e.vals;
            int i = 0;
            while (U.isPair(vars)) {
                LexicalEnvironment.show0(s, U.first(vars), vals[i]);
                vars = U.rest(vars);
                ++i;
            }
            if (vars != Pair.EMPTY) {
                LexicalEnvironment.show0(s, vars, vals[i]);
            }
            e = e.parent;
        }
    }

    private static void show0(PrintWriter s, Object var, Object val) {
        String sval = LexicalEnvironment.showValue(val);
        if (sval.length() > 100) {
            sval = sval.substring(0, 100) + "...";
        }
        s.println("  " + U.stringify(var) + " = " + sval);
    }

    private static String showValue(Object x) {
        if (BacktraceException.checkBacktrace()) {
            Object btvsProc = Scheme.currentEvaluator().getInteractionEnvironment().getValue(Symbol.intern("backtraceValueString"));
            return (String)U.toProc(btvsProc).apply(JScheme.list(x));
        }
        return x == null ? "null" : x.toString();
    }
}

