/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import jscheme.JS;
import jsint.DynamicEnvironment;
import jsint.E;
import jsint.Evaluator;
import jsint.Import;
import jsint.InputPort;
import jsint.Pair;
import jsint.Symbol;
import jsint.U;

public class Scheme {
    public static String[] ARGS;
    private static ThreadLocal currentEvaluatorStack;

    public static boolean isInterruptable() {
        return Scheme.currentEvaluator().INTERRUPTABLE;
    }

    public static void interruptCheck() {
        Scheme.currentEvaluator().interruptCheck();
    }

    private static LinkedList evaluatorStack() {
        return (LinkedList)currentEvaluatorStack.get();
    }

    public static Evaluator currentEvaluator() {
        try {
            return (Evaluator)Scheme.evaluatorStack().getFirst();
        }
        catch (NoSuchElementException e) {
            Scheme.pushEvaluator(JS.js.getEvaluator());
            return (Evaluator)Scheme.evaluatorStack().getFirst();
        }
    }

    public static void pushEvaluator(Evaluator i) {
        Scheme.evaluatorStack().addFirst(i);
    }

    public static Evaluator popEvaluator() {
        return (Evaluator)Scheme.evaluatorStack().removeFirst();
    }

    public static DynamicEnvironment getInteractionEnvironment() {
        return Scheme.currentEvaluator().interactionEnvironment;
    }

    public static DynamicEnvironment getNullEnvironment() {
        return Evaluator.NULL_ENVIRONMENT;
    }

    public static DynamicEnvironment getInitialEnvironment() {
        return Scheme.currentEvaluator().INITIAL_ENVIRONMENT;
    }

    public static void main(String[] files) {
        ARGS = files;
        if (!Scheme.loadInit()) {
            Scheme.defaultMain(files);
        }
    }

    public static void defaultMain(String[] files) {
        String main = null;
        String[] mainArgs = null;
        for (int i = 0; i < (files == null ? 0 : files.length); ++i) {
            if (files[i].startsWith("(")) {
                Scheme.load(new InputPort(new StringReader(files[i])));
                continue;
            }
            if (files[i].startsWith("-")) {
                if (files[i].equals("-s")) {
                    U.useJavaSyntax = false;
                    continue;
                }
                if (files[i].equals("-j")) {
                    U.useJavaSyntax = true;
                    continue;
                }
                if (files[i].equals("-main")) {
                    main = files[++i];
                    mainArgs = Scheme.consumeArgs(files, i + 1);
                    break;
                }
                Scheme.usage(files[i]);
                continue;
            }
            Scheme.load(files[i]);
        }
        if (main == null) {
            Scheme.runJscheme();
        } else if (!main.equals("none")) {
            try {
                JS.call(main, mainArgs);
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void usage(String arg) {
        E.warn("Unrecognized flag: " + arg + "\n" + "Usage: \n" + "  java jsint.Scheme [-s][-j] [(s-expr)] [file] ... [-main procedure arg1 ...]\n\n" + "Where: \n" + "  -s   \n" + "    Use normal Scheme syntax for numbers and characters.\n\n" + "  -j   \n" + "    Use Javalike syntax for numbers and characters.\n\n" + "  (s-exp)  \n" + "    An argument that begins with \"(\" is evaluated.\n\n" + "  -main procedure arg1 ...\n" + "    Rather than starting the normal Scheme.main, \n" + "    collect arg1 ... into a String[] and apply procedure to it.\n" + "    If procedure is none, no main is started.\n");
        System.exit(1);
    }

    private static String[] consumeArgs(String[] files, int i) {
        String[] result = new String[files.length - i];
        int j = 0;
        while (i < files.length) {
            result[j++] = files[i++];
        }
        return result;
    }

    public static void runJscheme() {
        Scheme.currentEvaluator().runJscheme();
    }

    public static void readEvalWriteLoop(String prompt) {
        Scheme.currentEvaluator().readEvalWriteLoop(prompt);
    }

    public static boolean loadInit() {
        InputPort in = Scheme.open("init.scm");
        if (in != null) {
            Scheme.load(in);
            return true;
        }
        return false;
    }

    public static Object load(Object fileName) {
        String name = fileName.toString();
        InputPort iport = Scheme.open(name);
        if (iport == null) {
            return E.warn("(load) can't open \"" + fileName + "\"");
        }
        return Scheme.load(iport);
    }

    public static DynamicEnvironment loadEnvironment(Object x) {
        return Scheme.currentEvaluator().loadEnvironment(x);
    }

    public static Boolean environmentImport(Object x, Object prefix) {
        return Scheme.currentEvaluator().environmentImport(x, prefix);
    }

    public static Boolean languageImport(Object x) {
        return Scheme.currentEvaluator().languageImport(x);
    }

    public static InputPort open(String name) {
        InputPort ip = null;
        if (ip == null) {
            ip = Scheme.openFile(name);
        }
        if (ip == null) {
            ip = Scheme.openResource(name);
        }
        if (ip == null) {
            ip = Scheme.openURL(name);
        }
        return ip;
    }

    public static InputPort openURL(String url) {
        try {
            return new InputPort((InputStream)new URL(url).getContent());
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputPort openFile(String name) {
        try {
            return new InputPort(new FileInputStream(name));
        }
        catch (IOException fnf) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace(Scheme.currentEvaluator().getError());
            return null;
        }
    }

    public static InputPort openResource(String name) {
        try {
            ClassLoader loader = Import.getClassLoader();
            InputStream stream = loader == null ? ClassLoader.getSystemResourceAsStream(name) : loader.getResourceAsStream(name);
            return stream == null ? null : new InputPort(stream);
        }
        catch (Throwable e) {
            Scheme.currentEvaluator().getError().println("In openResource(" + name + "):");
            e.printStackTrace(Scheme.currentEvaluator().getError());
            return null;
        }
    }

    public static Object load(InputPort in) {
        return Scheme.currentEvaluator().load(in);
    }

    public static Object evalToplevel(Object x, DynamicEnvironment env) {
        return Scheme.currentEvaluator().evalToplevel(x, env);
    }

    public static Object eval(Object x) {
        return Scheme.currentEvaluator().eval(x);
    }

    public static Object eval(Object x, Object env) {
        return Scheme.currentEvaluator().eval(x, env);
    }

    public static Object toBody(Object exps) {
        Pair parts = Scheme.extractDefines(Pair.EMPTY, U.toPair(exps));
        Pair defines = (Pair)parts.first;
        Pair body = (Pair)parts.rest;
        if (U.isPair(defines)) {
            Pair vars = Pair.EMPTY;
            Pair sets = Pair.EMPTY;
            Pair vals = Pair.EMPTY;
            Pair ds = defines;
            while (U.isPair(ds)) {
                Pair d = (Pair)ds.first;
                ds = (Pair)ds.rest;
                vars = new Pair(U.second(d), vars);
                sets = new Pair(U.list(Symbol.SET, d.second(), d.third()), sets);
                vals = new Pair(U.FALSE, vals);
            }
            Pair begin = new Pair(Symbol.BEGIN, U.append(U.list(sets.reverse(), body)));
            return new Pair(U.list(Symbol.LAMBDA, vars.reverse(), begin), vals);
        }
        return new Pair(Symbol.BEGIN, body);
    }

    private static Pair extractDefines(Pair defines, Pair body) {
        if (!U.isPair(body)) {
            return new Pair(defines.reverse(), body);
        }
        if (Scheme.startsWith(body.first, Symbol.BEGIN)) {
            return Scheme.extractDefines(defines, (Pair)U.append(U.list(U.rest(U.first(body)), body.rest)));
        }
        if (Scheme.startsWith(body.first, Symbol.DEFINE)) {
            return Scheme.extractDefines(new Pair(Scheme.simplifyDefine((Pair)body.first), defines), U.toList(body.rest));
        }
        return new Pair(defines.reverse(), Scheme.checkForDefines(body));
    }

    private static Object checkForDefines(Pair body) {
        if (!U.isPair(body)) {
            return body;
        }
        if (Scheme.startsWith(body.first, Symbol.BEGIN)) {
            return Scheme.checkForDefines((Pair)U.append(U.list(U.rest(U.first(body)), body.rest)));
        }
        if (Scheme.startsWith(body.first, Symbol.DEFINE)) {
            return E.error("Jscheme requires all embedded defines to appear first in procedure bodies\nYou must move " + U.stringify(U.first(body)) + " up\n");
        }
        return new Pair(body.first, Scheme.checkForDefines((Pair)body.rest));
    }

    private static boolean startsWith(Object list, Object atom) {
        return U.isPair(list) && U.first(list) == atom;
    }

    private static Pair simplifyDefine(Pair definition) {
        Object var = U.second(definition);
        if (var instanceof Pair) {
            Pair var2 = (Pair)var;
            Object name = var2.first;
            Object args = var2.rest;
            Object body = U.rest(U.rest(definition));
            return new Pair(Symbol.DEFINE, new Pair(name, U.list(new Pair(Symbol.LAMBDA, new Pair(args, body)))));
        }
        return definition;
    }

    static {
        currentEvaluatorStack = new InheritableThreadLocal(){

            protected Object initialValue() {
                return new LinkedList();
            }

            protected Object childValue(Object parentValue) {
                return new LinkedList((LinkedList)parentValue);
            }
        };
    }
}

