/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.io.Serializable;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;

public final class ClassName
implements Comparable<ClassName>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Log.getLogger();
    private static final ClassName OBJECT = new ClassName("java/lang/Object");
    private static final ClassName STRING = new ClassName("java/lang/String");
    private final String name;

    private ClassName(String name) {
        this.name = name;
    }

    public static ClassName fromClass(Class<?> clazz) {
        return ClassName.fromString(clazz.getName());
    }

    public static ClassName fromString(String clazz) {
        String name = clazz.replace('.', '/');
        if (name.equals(OBJECT.asInternalName())) {
            return OBJECT;
        }
        if (name.equals(STRING.asInternalName())) {
            return STRING;
        }
        return new ClassName(name);
    }

    public String asJavaName() {
        return this.name.replace('/', '.');
    }

    public String asInternalName() {
        return this.name;
    }

    public ClassName getNameWithoutPackage() {
        int lastSeparator = this.name.lastIndexOf(47);
        if (lastSeparator != -1) {
            return ClassName.fromString(this.name.substring(lastSeparator + 1, this.name.length()));
        }
        return this;
    }

    public ClassName getPackage() {
        int lastSeparator = this.name.lastIndexOf(47);
        if (lastSeparator != -1) {
            return ClassName.fromString(this.name.substring(0, lastSeparator));
        }
        return ClassName.fromString("");
    }

    public ClassName withoutPrefixChars(int prefixLength) {
        String nameWithoutPackage = this.getNameWithoutPackage().asJavaName();
        return ClassName.fromString(this.getPackage().asJavaName() + "/" + nameWithoutPackage.substring(prefixLength, nameWithoutPackage.length()));
    }

    public ClassName withoutSuffixChars(int suffixLength) {
        String nameWithoutPacakge = this.getNameWithoutPackage().asJavaName();
        return ClassName.fromString(this.getPackage().asJavaName() + "/" + nameWithoutPacakge.substring(0, nameWithoutPacakge.length() - suffixLength));
    }

    public static Function<String, ClassName> stringToClassName() {
        return clazz -> ClassName.fromString(clazz);
    }

    public static Function<ClassName, Stream<Class<?>>> nameToClass() {
        return ClassName.nameToClass(IsolationUtils.getContextClassLoader());
    }

    public static Function<ClassName, Stream<Class<?>>> nameToClass(ClassLoader loader) {
        return className -> {
            try {
                Class<?> clazz = Class.forName(className.asJavaName(), false, loader);
                return Stream.of(clazz);
            }
            catch (ClassNotFoundException e1) {
                LOG.warning("Could not load " + className + " (ClassNotFoundException: " + e1.getMessage() + ")");
                return Stream.empty();
            }
            catch (NoClassDefFoundError e2) {
                LOG.warning("Could not load " + className + " (NoClassDefFoundError: " + e2.getMessage() + ")");
                return Stream.empty();
            }
            catch (LinkageError e3) {
                LOG.warning("Could not load " + className + " " + e3.getMessage());
                return Stream.empty();
            }
            catch (SecurityException e4) {
                LOG.warning("Could not load " + className + " " + e4.getMessage());
                return Stream.empty();
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassName other = (ClassName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.asJavaName();
    }

    @Override
    public int compareTo(ClassName o) {
        return this.asJavaName().compareTo(o.asJavaName());
    }
}

