/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.util.Glob;
import org.pitest.util.Preconditions;

public class CoverageOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<String> include;
    private final Collection<String> exclude;
    private final boolean verbose;
    private final TestPluginArguments pitConfig;
    private final int maxDependencyDistance;

    public CoverageOptions(Collection<String> include, Collection<String> exclude, TestPluginArguments pitConfig, boolean verbose, int maxDependencyDistance) {
        Preconditions.checkNotNull(pitConfig);
        this.include = include;
        this.exclude = exclude;
        this.verbose = verbose;
        this.pitConfig = pitConfig;
        this.maxDependencyDistance = maxDependencyDistance;
    }

    public Predicate<String> getFilter() {
        return Prelude.and(Prelude.or(Glob.toGlobPredicates(this.include)), Prelude.not(Prelude.or(Glob.toGlobPredicates(this.exclude))), Prelude.not(CoverageOptions.commonClasses()));
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public TestPluginArguments getPitConfig() {
        return this.pitConfig;
    }

    public int getDependencyAnalysisMaxDistance() {
        return this.maxDependencyDistance;
    }

    private static Predicate<String> commonClasses() {
        return Prelude.or(CoverageOptions.glob("java/*"), CoverageOptions.glob("sun/*"), CoverageOptions.glob("org/pitest/coverage/*"), CoverageOptions.glob("org/pitest/reloc/*"), CoverageOptions.glob("org/pitest/boot/*"));
    }

    private static Glob glob(String match) {
        return new Glob(match);
    }
}

