/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.config.ClientPluginServices;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestPluginFactory;
import org.pitest.util.PitError;

public class MinionSettings {
    private final ClientPluginServices plugins;

    public MinionSettings(ClientPluginServices plugins) {
        this.plugins = plugins;
    }

    public MutationEngineFactory createEngine(String engine) {
        for (MutationEngineFactory mutationEngineFactory : this.plugins.findMutationEngines()) {
            if (!mutationEngineFactory.name().equals(engine)) continue;
            return mutationEngineFactory;
        }
        throw new PitError("Could not load requested engine " + engine);
    }

    public Configuration getTestFrameworkPlugin(TestPluginArguments options, ClassByteArraySource source) {
        for (TestPluginFactory testPluginFactory : this.plugins.findTestFrameworkPlugins()) {
            if (!testPluginFactory.name().equals(options.getTestPlugin())) continue;
            return testPluginFactory.createTestFrameworkConfiguration(options.getGroupConfig(), source, options.getExcludedRunners(), options.getIncludedTestMethods());
        }
        throw new PitError("Could not load requested test plugin " + options.getTestPlugin());
    }
}

