/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

public class AvoidStringSwitchedMethodAdapter
extends MethodVisitor {
    private static final String DISABLE_REASON = "STRING_SWITCH";
    private final MutationContext context;
    private boolean hashCodeWasLastCall;
    private Label end;

    public AvoidStringSwitchedMethodAdapter(MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(458752, delegateMethodVisitor);
        this.context = context;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.hashCodeWasLastCall = opcode == 182 && "java/lang/String".equals(owner) && "hashCode".equals(name);
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.enableMutation();
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this.hashCodeWasLastCall) {
            this.context.disableMutations(DISABLE_REASON);
            this.end = dflt;
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this.hashCodeWasLastCall) {
            this.context.disableMutations(DISABLE_REASON);
            this.end = dflt;
        }
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (this.end == label) {
            this.enableMutation();
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.hashCodeWasLastCall = false;
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.hashCodeWasLastCall = false;
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitInsn(int opcode) {
        this.hashCodeWasLastCall = false;
        super.visitInsn(opcode);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.enableMutation();
    }

    private void enableMutation() {
        this.context.enableMutatations(DISABLE_REASON);
        this.end = null;
        this.hashCodeWasLastCall = false;
    }
}

