/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.rv;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.util.PitError;

public abstract class AbstractCRCRVisitor
extends MethodVisitor {
    final MutationContext context;
    final MethodMutatorFactory factory;

    AbstractCRCRVisitor(MutationContext context, MethodVisitor delegateVisitor, MethodMutatorFactory factory) {
        super(458752, delegateVisitor);
        this.context = context;
        this.factory = factory;
    }

    abstract void mutate(Double var1);

    abstract void mutate(Float var1);

    abstract void mutate(Integer var1);

    abstract void mutate(Long var1);

    void mutate(Number constant) {
        if (constant instanceof Integer) {
            this.mutate((Integer)constant);
        } else if (constant instanceof Long) {
            this.mutate((Long)constant);
        } else if (constant instanceof Float) {
            this.mutate((Float)constant);
        } else if (constant instanceof Double) {
            this.mutate((Double)constant);
        } else {
            throw new PitError("Unsupported subtype of Number found:" + constant.getClass());
        }
    }

    <T extends Number> boolean shouldMutate(T constant, T replacement) {
        MutationIdentifier mutationId = this.context.registerMutation(this.factory, "Substituted " + constant + " with " + replacement);
        return this.context.shouldMutate(mutationId);
    }

    void translateToByteCode(Double constant) {
        if (constant == 0.0) {
            super.visitInsn(14);
        } else if (constant == 1.0) {
            super.visitInsn(15);
        } else {
            super.visitLdcInsn(constant);
        }
    }

    void translateToByteCode(Float constant) {
        if (constant.floatValue() == 0.0f) {
            super.visitInsn(11);
        } else if (constant.floatValue() == 1.0f) {
            super.visitInsn(12);
        } else if (constant.floatValue() == 2.0f) {
            super.visitInsn(13);
        } else {
            super.visitLdcInsn(constant);
        }
    }

    void translateToByteCode(Integer constant) {
        switch (constant) {
            case -1: {
                super.visitInsn(2);
                break;
            }
            case 0: {
                super.visitInsn(3);
                break;
            }
            case 1: {
                super.visitInsn(4);
                break;
            }
            case 2: {
                super.visitInsn(5);
                break;
            }
            case 3: {
                super.visitInsn(6);
                break;
            }
            case 4: {
                super.visitInsn(7);
                break;
            }
            case 5: {
                super.visitInsn(8);
                break;
            }
            default: {
                super.visitLdcInsn(constant);
            }
        }
    }

    void translateToByteCode(Long constant) {
        if (constant == 0L) {
            super.visitInsn(9);
        } else if (constant == 1L) {
            super.visitInsn(10);
        } else {
            super.visitLdcInsn(constant);
        }
    }

    Number translateToNumber(int opcode) {
        switch (opcode) {
            case 2: {
                return -1;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 0L;
            }
            case 10: {
                return 1L;
            }
            case 11: {
                return Float.valueOf(0.0f);
            }
            case 12: {
                return Float.valueOf(1.0f);
            }
            case 13: {
                return Float.valueOf(2.0f);
            }
            case 14: {
                return 0.0;
            }
            case 15: {
                return 1.0;
            }
        }
        return null;
    }

    @Override
    public void visitInsn(int opcode) {
        Number inlineConstant = this.translateToNumber(opcode);
        if (inlineConstant == null) {
            super.visitInsn(opcode);
            return;
        }
        this.mutate(inlineConstant);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 16 || opcode == 17) {
            this.mutate(operand);
        } else {
            super.visitIntInsn(opcode, operand);
        }
    }

    @Override
    public void visitLdcInsn(Object constant) {
        if (constant instanceof Number) {
            this.mutate((Number)constant);
        } else {
            super.visitLdcInsn(constant);
        }
    }
}

