/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.pitest.functional.FCollection;
import org.pitest.plugin.FeatureSetting;
import org.pitest.plugin.ToggleStatus;

public class FeatureParser {
    public List<FeatureSetting> parseFeatures(Collection<String> config) {
        return FCollection.map(config, this.stringToSettings());
    }

    private Function<String, FeatureSetting> stringToSettings() {
        return a -> {
            String text = a.trim();
            ToggleStatus status = this.parseStatus(text);
            String name = this.parseName(text);
            return new FeatureSetting(name, status, this.parseConfig(text));
        };
    }

    private Map<String, List<String>> parseConfig(String a) {
        HashMap<String, List<String>> vals = new HashMap<String, List<String>>();
        int confStart = a.indexOf(40) + 1;
        int end = a.indexOf(41);
        if (confStart != -1 && confStart < end) {
            String[] parts;
            for (String part : parts = this.split(a.substring(confStart, end))) {
                this.extractValue(part, vals);
            }
        }
        return vals;
    }

    private void extractValue(String part, Map<String, List<String>> vals) {
        String[] pairs = part.split("\\[");
        for (int i = 0; i != pairs.length; i += 2) {
            String key = pairs[i].trim();
            List<String> current = vals.get(key);
            if (current == null) {
                current = new ArrayList<String>();
            }
            current.add(pairs[i + 1].trim());
            vals.put(key, current);
        }
    }

    private String[] split(String body) {
        return body.split("\\]");
    }

    private String parseName(String a) {
        String name = a.substring(1, a.length());
        int confStart = name.indexOf(40);
        if (confStart == -1) {
            return name;
        }
        return name.substring(0, confStart);
    }

    private ToggleStatus parseStatus(String a) {
        if (a.startsWith("+")) {
            return ToggleStatus.ACTIVATE;
        }
        if (a.startsWith("-")) {
            return ToggleStatus.DEACTIVATE;
        }
        throw new RuntimeException("Could not parse " + a + " should start with + or -");
    }
}

