/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassInfoSource;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.NameToClassInfo;
import org.pitest.classinfo.Repository;
import org.pitest.classinfo.TestToClassMapper;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.functional.FCollection;
import org.pitest.functional.Streams;

public class CodeSource
implements ClassInfoSource {
    private final ProjectClassPaths classPath;
    private final Repository classRepository;

    public CodeSource(ProjectClassPaths classPath) {
        this(classPath, new Repository(new ClassPathByteArraySource(classPath.getClassPath())));
    }

    CodeSource(ProjectClassPaths classPath, Repository classRepository) {
        this.classPath = classPath;
        this.classRepository = classRepository;
    }

    public Collection<ClassInfo> getCode() {
        return this.classPath.code().stream().flatMap(this.nameToClassInfo()).collect(Collectors.toList());
    }

    public Set<ClassName> getCodeUnderTestNames() {
        HashSet<ClassName> codeClasses = new HashSet<ClassName>();
        FCollection.mapTo(this.getCode(), ClassInfo.toClassName(), codeClasses);
        return codeClasses;
    }

    public List<ClassInfo> getTests() {
        return this.classPath.test().stream().flatMap(this.nameToClassInfo()).filter(ClassInfo.matchIfAbstract().negate()).collect(Collectors.toList());
    }

    public ClassPath getClassPath() {
        return this.classPath.getClassPath();
    }

    public ProjectClassPaths getProjectPaths() {
        return this.classPath;
    }

    public Optional<ClassName> findTestee(String className) {
        TestToClassMapper mapper = new TestToClassMapper(this.classRepository);
        return mapper.findTestee(className);
    }

    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return classes.stream().flatMap(this.nameToClassInfo()).collect(Collectors.toList());
    }

    public Optional<byte[]> fetchClassBytes(ClassName clazz) {
        return this.classRepository.querySource(clazz);
    }

    @Override
    public Optional<ClassInfo> fetchClass(ClassName clazz) {
        return this.classRepository.fetchClass(clazz);
    }

    private Function<ClassName, Stream<ClassInfo>> nameToClassInfo() {
        return new NameToClassInfo(this.classRepository).andThen(opt -> Streams.fromOptional(opt));
    }
}

