/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pitest.coverage.CoverageReceiver;
import org.pitest.coverage.execute.CoverageDecorator;
import org.pitest.coverage.execute.CoveragePipe;
import org.pitest.coverage.execute.ErrorListener;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.execute.Pitest;
import org.pitest.testapi.execute.containers.UnContainer;
import org.pitest.util.Unchecked;

public class CoverageWorker {
    private final CoveragePipe pipe;
    private final List<TestUnit> tests;

    public CoverageWorker(CoveragePipe pipe, List<TestUnit> tests) {
        this.pipe = pipe;
        this.tests = tests;
    }

    public void run() {
        try {
            List<TestUnit> decoratedTests = CoverageWorker.decorateForCoverage(this.tests, this.pipe);
            Collections.sort(decoratedTests, CoverageWorker.testComparator());
            UnContainer c = new UnContainer();
            Pitest pit = new Pitest(new ErrorListener());
            pit.run(c, decoratedTests);
        }
        catch (Exception ex) {
            throw Unchecked.translateCheckedException(ex);
        }
    }

    private static Comparator<TestUnit> testComparator() {
        return (o1, o2) -> o1.getDescription().getQualifiedName().compareTo(o2.getDescription().getQualifiedName());
    }

    private static List<TestUnit> decorateForCoverage(List<TestUnit> plainTests, CoverageReceiver queue) {
        ArrayList<TestUnit> decorated = new ArrayList<TestUnit>(plainTests.size());
        for (TestUnit each : plainTests) {
            decorated.add(new CoverageDecorator(queue, each));
        }
        return decorated;
    }
}

