/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.Optional;
import java.util.function.Predicate;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.pitest.classinfo.ClassInfo;

abstract class TestInfo {
    TestInfo() {
    }

    public static boolean isWithinATestClass(ClassInfo clazz) {
        Optional<ClassInfo> outerClass = clazz.getOuterClass();
        return TestInfo.isATest(clazz) || outerClass.isPresent() && TestInfo.isATest(outerClass.get());
    }

    private static boolean isATest(ClassInfo clazz) {
        return TestInfo.isJUnit3Test(clazz) || TestInfo.isJUnit4Test(clazz) || TestInfo.isATest(clazz.getSuperClass());
    }

    private static boolean isATest(Optional<ClassInfo> clazz) {
        if (clazz.isPresent()) {
            return TestInfo.isATest(clazz.get());
        }
        return false;
    }

    public static Predicate<ClassInfo> isATest() {
        return clazz -> TestInfo.isATest(clazz);
    }

    private static boolean isJUnit3Test(ClassInfo clazz) {
        return clazz.descendsFrom(TestCase.class) || clazz.descendsFrom(TestSuite.class);
    }

    private static boolean isJUnit4Test(ClassInfo clazz) {
        return clazz.hasAnnotation(RunWith.class) || clazz.hasAnnotation(Test.class);
    }
}

