/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.pitest.mutationtest.DetectionStatus;

public final class MutationStatusTestPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int numberOfTestsRun;
    private final DetectionStatus status;
    private final List<String> killingTests;
    private final List<String> succeedingTests;

    public static MutationStatusTestPair notAnalysed(int testsRun, DetectionStatus status) {
        return new MutationStatusTestPair(testsRun, status, Collections.emptyList(), Collections.emptyList());
    }

    public MutationStatusTestPair(int numberOfTestsRun, DetectionStatus status, String killingTest) {
        this(numberOfTestsRun, status, MutationStatusTestPair.killingTestToList(killingTest), Collections.emptyList());
    }

    public MutationStatusTestPair(int numberOfTestsRun, DetectionStatus status, List<String> killingTests, List<String> succeedingTests) {
        this.status = status;
        this.killingTests = killingTests;
        this.succeedingTests = succeedingTests;
        this.numberOfTestsRun = numberOfTestsRun;
    }

    private static List<String> killingTestToList(String killingTest) {
        if (killingTest == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(killingTest);
    }

    public DetectionStatus getStatus() {
        return this.status;
    }

    public Optional<String> getKillingTest() {
        if (this.killingTests.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.killingTests.get(0));
    }

    public List<String> getKillingTests() {
        return this.killingTests;
    }

    public List<String> getSucceedingTests() {
        return this.succeedingTests;
    }

    public int getNumberOfTestsRun() {
        return this.numberOfTestsRun;
    }

    public String toString() {
        if (this.killingTests.isEmpty()) {
            return this.status.name();
        }
        return this.status.name() + " by " + this.killingTests;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.killingTests == null ? 0 : this.killingTests.hashCode());
        result = 31 * result + (this.succeedingTests == null ? 0 : this.succeedingTests.hashCode());
        result = 31 * result + this.numberOfTestsRun;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationStatusTestPair other = (MutationStatusTestPair)obj;
        if (!Objects.equals(this.killingTests, other.killingTests)) {
            return false;
        }
        if (!Objects.equals(this.succeedingTests, other.succeedingTests)) {
            return false;
        }
        if (this.numberOfTestsRun != other.numberOfTestsRun) {
            return false;
        }
        return this.status == other.status;
    }
}

