/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.engine.gregor.GregorMutater;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationEngineConfiguration;

public class GregorMutationEngine
implements MutationEngine {
    private final Set<MethodMutatorFactory> mutationOperators = new LinkedHashSet<MethodMutatorFactory>();
    private final Predicate<MethodInfo> methodFilter;

    public GregorMutationEngine(MutationEngineConfiguration config) {
        this.methodFilter = config.methodFilter();
        this.mutationOperators.addAll(config.mutators());
    }

    @Override
    public Mutater createMutator(ClassByteArraySource byteSource) {
        return new GregorMutater(byteSource, this.methodFilter, this.mutationOperators);
    }

    public String toString() {
        return "GregorMutationEngine [filter=" + this.methodFilter + ", mutationOperators=" + this.mutationOperators + "]";
    }

    @Override
    public Collection<String> getMutatorNames() {
        return FCollection.map(this.mutationOperators, GregorMutationEngine.toName());
    }

    private static Function<MethodMutatorFactory, String> toName() {
        return a -> a.getName();
    }

    @Override
    public String getName() {
        return "gregor";
    }
}

