/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import java.util.HashMap;
import java.util.Map;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.gregor.AbstractInsnMutator;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.ZeroOperandMutation;
import org.pitest.reloc.asm.MethodVisitor;

class BooleanTrueMethodVisitor
extends AbstractInsnMutator {
    private static final String BOOLEAN = ClassName.fromClass(Boolean.class).asInternalName();
    private static final Map<Integer, ZeroOperandMutation> MUTATIONS = new HashMap<Integer, ZeroOperandMutation>();

    BooleanTrueMethodVisitor(MethodMutatorFactory factory, MethodInfo methodInfo, MutationContext context, MethodVisitor writer) {
        super(factory, methodInfo, context, writer);
    }

    private static ZeroOperandMutation ireturnMutation() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opCode, MethodVisitor mv) {
                mv.visitInsn(87);
                mv.visitInsn(4);
                mv.visitInsn(172);
            }

            @Override
            public String decribe(int opCode, MethodInfo methodInfo) {
                return "replaced boolean return with true for " + methodInfo.getDescription();
            }
        };
    }

    private static ZeroOperandMutation areturnMutation() {
        return new ZeroOperandMutation(){

            @Override
            public void apply(int opCode, MethodVisitor mv) {
                mv.visitInsn(87);
                mv.visitInsn(4);
                mv.visitMethodInsn(184, BOOLEAN, "valueOf", "(Z)Ljava/lang/Boolean;", false);
                mv.visitInsn(176);
            }

            @Override
            public String decribe(int opCode, MethodInfo methodInfo) {
                return "replaced Boolean return with True for " + methodInfo.getDescription();
            }
        };
    }

    @Override
    protected Map<Integer, ZeroOperandMutation> getMutations() {
        return MUTATIONS;
    }

    static {
        MUTATIONS.put(172, BooleanTrueMethodVisitor.ireturnMutation());
        MUTATIONS.put(176, BooleanTrueMethodVisitor.areturnMutation());
    }
}

