/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators;

import java.util.ArrayList;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

public class RemoveConditionalMutator
implements MethodMutatorFactory {
    private final Choice kind;
    private final boolean replaceWith;

    public RemoveConditionalMutator(Choice c, boolean rc) {
        this.kind = c;
        this.replaceWith = rc;
    }

    public static Iterable<MethodMutatorFactory> makeMutators() {
        ArrayList<MethodMutatorFactory> variations = new ArrayList<MethodMutatorFactory>();
        Choice[] allChoices = new Choice[]{Choice.EQUAL, Choice.ORDER};
        boolean[] arrWith = new boolean[]{true, false};
        for (Choice c : allChoices) {
            for (boolean b : arrWith) {
                variations.add(new RemoveConditionalMutator(c, b));
            }
        }
        return variations;
    }

    @Override
    public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new RemoveConditionalMethodVisitor(this, context, methodVisitor, "removed conditional - replaced " + this.kind.description() + " check with " + this.replaceWith);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName() + "_" + (Object)((Object)this.kind) + "_" + (this.replaceWith ? "IF" : "ELSE");
    }

    @Override
    public String getName() {
        return "REMOVE_CONDITIONALS_" + (Object)((Object)this.kind) + "_" + (this.replaceWith ? "IF" : "ELSE") + "_MUTATOR";
    }

    private final class RemoveConditionalMethodVisitor
    extends MethodVisitor {
        private final String description;
        private final MutationContext context;
        private final MethodMutatorFactory factory;

        RemoveConditionalMethodVisitor(MethodMutatorFactory factory, MutationContext context, MethodVisitor delegateMethodVisitor, String description) {
            super(458752, delegateMethodVisitor);
            this.context = context;
            this.factory = factory;
            this.description = description;
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            if (this.canMutate(opcode)) {
                MutationIdentifier newId = this.context.registerMutation(this.factory, this.description);
                if (this.context.shouldMutate(newId)) {
                    this.emptyStack(opcode);
                    if (!RemoveConditionalMutator.this.replaceWith) {
                        super.visitJumpInsn(167, label);
                    }
                } else {
                    this.mv.visitJumpInsn(opcode, label);
                }
            } else {
                this.mv.visitJumpInsn(opcode, label);
            }
        }

        private void emptyStack(int opcode) {
            switch (opcode) {
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    super.visitInsn(88);
                    break;
                }
                default: {
                    super.visitInsn(87);
                }
            }
        }

        private boolean canMutate(int opcode) {
            switch (opcode) {
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    return RemoveConditionalMutator.this.kind == Choice.ORDER;
                }
                case 153: 
                case 154: 
                case 159: 
                case 160: 
                case 165: 
                case 166: 
                case 198: 
                case 199: {
                    return RemoveConditionalMutator.this.kind == Choice.EQUAL;
                }
            }
            return false;
        }
    }

    public static enum Choice {
        EQUAL("equality"),
        ORDER("comparison");

        private String desc;

        private Choice(String desc) {
            this.desc = desc;
        }

        String description() {
            return this.desc;
        }
    }
}

