/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.experimental;

import java.util.ArrayList;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;

public class RemoveSwitchMutator
implements MethodMutatorFactory {
    private static final String REMOVE_SWITCH_MUTATOR_NAME = "EXPERIMENTAL_REMOVE_SWITCH_MUTATOR_";
    private static final int GENERATE_FROM_INCLUDING = 0;
    private static final int GENERATE_UPTO_EXCLUDING = 100;
    private final int key;

    RemoveSwitchMutator(int i) {
        this.key = i;
    }

    public static Iterable<MethodMutatorFactory> makeMutators() {
        ArrayList<MethodMutatorFactory> variations = new ArrayList<MethodMutatorFactory>();
        for (int i = 0; i != 100; ++i) {
            variations.add(new RemoveSwitchMutator(i));
        }
        return variations;
    }

    @Override
    public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new RemoveSwitchMethodVisitor(context, methodVisitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName() + "_" + this.key;
    }

    @Override
    public String getName() {
        return "EXPERIMENTAL_REMOVE_SWITCH_MUTATOR_[0-99]";
    }

    public String toString() {
        return REMOVE_SWITCH_MUTATOR_NAME + this.key;
    }

    private final class RemoveSwitchMethodVisitor
    extends MethodVisitor {
        private final MutationContext context;

        RemoveSwitchMethodVisitor(MutationContext context, MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.context = context;
        }

        @Override
        public void visitTableSwitchInsn(int i, int i1, Label defaultLabel, Label ... labels) {
            if (labels.length > RemoveSwitchMutator.this.key && this.shouldMutate()) {
                Label[] newLabels = (Label[])labels.clone();
                newLabels[((RemoveSwitchMutator)RemoveSwitchMutator.this).key] = defaultLabel;
                super.visitTableSwitchInsn(i, i1, defaultLabel, newLabels);
            } else {
                super.visitTableSwitchInsn(i, i1, defaultLabel, labels);
            }
        }

        @Override
        public void visitLookupSwitchInsn(Label defaultLabel, int[] ints, Label[] labels) {
            if (labels.length > RemoveSwitchMutator.this.key && this.shouldMutate()) {
                Label[] newLabels = (Label[])labels.clone();
                newLabels[((RemoveSwitchMutator)RemoveSwitchMutator.this).key] = defaultLabel;
                super.visitLookupSwitchInsn(defaultLabel, ints, newLabels);
            } else {
                super.visitLookupSwitchInsn(defaultLabel, ints, labels);
            }
        }

        private boolean shouldMutate() {
            MutationIdentifier mutationId = this.context.registerMutation(RemoveSwitchMutator.this, "RemoveSwitch " + RemoveSwitchMutator.this.key + " mutation");
            return this.context.shouldMutate(mutationId);
        }
    }
}

