/*
 * Decompiled with CFR 0.152.
 */
package interact;

import interact.IOTextArea;
import java.io.IOException;
import java.io.Writer;

public class IOTextAreaWriter
extends Writer {
    private IOTextArea area;

    public IOTextAreaWriter(IOTextArea area) {
        this.area = area;
    }

    private void ensureOpen() throws IOException {
        if (this.area == null) {
            throw new IOException("Writer " + this + " closed");
        }
    }

    public void write(String s) throws IOException {
        this.ensureOpen();
        this.area.write(s);
    }

    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        if (off == 0 && len == s.length()) {
            this.area.write(s);
        } else {
            super.write(s, off, len);
        }
    }

    public synchronized void write(char[] buf, int off, int len) throws IOException {
        this.ensureOpen();
        this.area.write(buf, off, len);
    }

    public synchronized void flush() throws IOException {
        this.ensureOpen();
    }

    public synchronized void close() throws IOException {
        this.ensureOpen();
        this.area = null;
    }
}

