/*
 * Decompiled with CFR 0.152.
 */
package interact;

import interact.IOTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import jscheme.JScheme;
import jsint.BacktraceException;
import jsint.Evaluator;
import jsint.InputPort;
import jsint.Procedure;
import jsint.Scheme;
import jsint.U;

public class Interactor
implements Runnable {
    JFrame frame;
    private IOTextArea area;
    private Reader in;
    private PrintWriter out;
    String name;
    int rows;
    int cols;
    Object[] pairs;
    String[] files;
    JScheme js;

    private IOTextArea getArea() {
        if (this.area == null) {
            this.area = new IOTextArea(this.rows, this.cols);
            this.area.setFont(new Font("monospaced", 0, 12));
        }
        return this.area;
    }

    private Reader getReader() {
        if (this.in == null) {
            this.in = this.getArea().getReader();
        }
        return this.in;
    }

    private PrintWriter getWriter() {
        if (this.out == null) {
            this.out = new PrintWriter(this.getArea().getWriter());
        }
        return this.out;
    }

    public Interactor(Object it) {
        this(it, new JScheme());
    }

    public Interactor(Object it, JScheme js) {
        this(new Object[]{"it", it}, js);
    }

    public Interactor(Object[] pairs, JScheme js) {
        this(true, "Interactor", pairs, 24, 80, null, js);
    }

    public Interactor(boolean newThread, String name, Object[] pairs, int rows, int cols, String[] files, JScheme js) {
        this.name = name;
        this.pairs = pairs;
        this.rows = rows;
        this.cols = cols;
        this.files = files;
        this.frame = this.createFrame();
        this.js = js;
        if (newThread) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    private JFrame createFrame() {
        JFrame frame = new JFrame(this.name);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Toolkit.getDefaultToolkit().beep();
                Interactor.this.getWriter().println("Type (exit) to exit this Frame!");
            }
        });
        Container pane = frame.getContentPane();
        JScrollPane scroll = new JScrollPane(this.getArea());
        pane.add((Component)scroll, "Center");
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public void readEvalWriteLoop(String prompt) {
        Scheme.readEvalWriteLoop(prompt);
    }

    public void run() {
        Scheme.pushEvaluator(this.js.getEvaluator());
        BacktraceException.printJavaTrace = true;
        Evaluator e = Scheme.currentEvaluator();
        e.setInput(new InputPort(this.getReader()));
        e.setOutput(this.getWriter());
        e.setError(this.getWriter());
        this.js.evalOrLoad("elf/basic.scm");
        this.importVariables();
        if (this.files != null) {
            this.loadFiles(this.files);
        }
        this.readEvalWriteLoop("> ");
        this.frame.dispose();
        this.frame = null;
        Scheme.popEvaluator();
    }

    private void loadFiles(String[] args) {
        for (int i = 0; i < (args == null ? 0 : args.length); ++i) {
            this.js.evalOrLoad(args[i]);
        }
    }

    private void importVariables() {
        Procedure importer = (Procedure)this.js.getGlobalValue("import");
        if (this.pairs != null) {
            this.js.call("display", (Object)"Bindings:\n");
            for (int i = 0; i < this.pairs.length; i += 2) {
                this.importVariable((String)this.pairs[i], this.pairs[i + 1]);
            }
        }
    }

    private void importVariable(String var, Object val) {
        this.js.setGlobalValue(var, val);
        this.js.call("import", (Object)val.getClass().getName());
        this.js.call("display", (Object)(var + " = " + U.stringify(val) + "\n"), (Object)Scheme.currentEvaluator().getOutput());
    }

    public static void main(String[] args) {
        new Interactor(false, "Interactor", new Object[]{"now", new Date()}, 24, 80, args, new JScheme());
        System.out.println("Interaction done!");
        System.exit(0);
    }
}

