/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;
import jscheme.SchemeSymbol;
import jsint.Scheme;

public class Symbol
implements Serializable,
SchemeSymbol {
    private String name;
    public static final Hashtable symbolTable = new Hashtable(500);
    public static final Symbol BEGIN = Symbol.intern("begin");
    public static final Symbol CAR = Symbol.intern("car");
    public static final Symbol CDR = Symbol.intern("cdr");
    public static final Symbol DEFINE = Symbol.intern("define");
    public static final Symbol IF = Symbol.intern("if");
    public static final Symbol LAMBDA = Symbol.intern("lambda");
    public static final Symbol MACRO = Symbol.intern("macro");
    public static final Symbol NEWLINE = Symbol.intern("newline");
    public static final Symbol NULL = Symbol.intern("null");
    public static final Symbol OR = Symbol.intern("or");
    public static final Symbol QUASIQUOTE = Symbol.intern("quasiquote");
    public static final Symbol QUOTE = Symbol.intern("quote");
    public static final Symbol SET = Symbol.intern("set!");
    public static final Symbol SPACE = Symbol.intern("space");
    public static final Symbol UNQUOTE = Symbol.intern("unquote");
    public static final Symbol UNQUOTE_SPLICING = Symbol.intern("unquote-splicing");
    public static final Symbol PACKAGE = Symbol.intern("package");

    private Symbol(String name) {
        this.name = name;
    }

    private Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.name);
    }

    public static synchronized Symbol intern(String name) {
        Symbol result = (Symbol)symbolTable.get(name);
        if (result == null) {
            result = new Symbol(name);
            symbolTable.put(name, result);
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public Object getGlobalValue() {
        return Scheme.getInteractionEnvironment().getValue(this);
    }

    public synchronized Object setGlobalValue(Object newval) {
        return Scheme.getInteractionEnvironment().setValue(this, newval);
    }

    public boolean isDefined() {
        return Scheme.getInteractionEnvironment().isDefined(this);
    }
}

