/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.util.ArrayList;
import org.pitest.bytecode.NullVisitor;
import org.pitest.classinfo.BridgeMethodFilter;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassInfoBuilder;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.InfoMethodVisitor;
import org.pitest.classinfo.MethodFilteringAdapter;
import org.pitest.reloc.asm.AnnotationVisitor;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

public final class ClassInfoVisitor
extends MethodFilteringAdapter {
    private final ClassInfoBuilder classInfo;

    private ClassInfoVisitor(ClassInfoBuilder classInfo, ClassVisitor writer) {
        super(writer, BridgeMethodFilter.INSTANCE);
        this.classInfo = classInfo;
    }

    public static ClassInfoBuilder getClassInfo(ClassName name, byte[] bytes, long hash) {
        ClassReader reader = new ClassReader(bytes);
        NullVisitor writer = new NullVisitor();
        ClassInfoBuilder info = new ClassInfoBuilder();
        info.id = new ClassIdentifier(hash, name);
        reader.accept(new ClassInfoVisitor(info, (ClassVisitor)writer), 0);
        return info;
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.classInfo.sourceFile = source;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classInfo.access = access;
        this.classInfo.superClass = superName;
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
        this.classInfo.outerClass = owner;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (outerName != null && this.classInfo.id.getName().equals(ClassName.fromString(name))) {
            this.classInfo.outerClass = outerName;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String type = desc.substring(1, desc.length() - 1);
        this.classInfo.registerAnnotation(type);
        return new ClassAnnotationValueVisitor(this.classInfo, ClassName.fromString(type));
    }

    @Override
    public MethodVisitor visitMethodIfRequired(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor methodVisitor) {
        return new InfoMethodVisitor(this.classInfo, methodVisitor);
    }

    private static class ClassAnnotationValueVisitor
    extends AnnotationVisitor {
        private final ClassInfoBuilder classInfo;
        private final ClassName annotation;

        ClassAnnotationValueVisitor(ClassInfoBuilder classInfo, ClassName annotation) {
            super(393216, null);
            this.classInfo = classInfo;
            this.annotation = annotation;
        }

        @Override
        public void visit(String name, Object value) {
            if (name.equals("value")) {
                this.classInfo.registerClassAnnotationValue(this.annotation, ClassAnnotationValueVisitor.simplify(value));
            }
            super.visit(name, value);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (name.equals("value")) {
                final ArrayList arrayValue = new ArrayList();
                return new AnnotationVisitor(393216, null){

                    @Override
                    public void visit(String name, Object value) {
                        arrayValue.add(ClassAnnotationValueVisitor.simplify(value));
                        super.visit(name, value);
                    }

                    @Override
                    public void visitEnd() {
                        ClassAnnotationValueVisitor.this.classInfo.registerClassAnnotationValue(ClassAnnotationValueVisitor.this.annotation, arrayValue.toArray());
                    }
                };
            }
            return super.visitArray(name);
        }

        private static Object simplify(Object value) {
            Object newValue = value;
            if (value instanceof Type) {
                newValue = ((Type)value).getClassName();
            }
            return newValue;
        }
    }
}

