/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.junit.ParameterisedTestFilter;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;

public class ParameterisedJUnitTestFinder
implements TestUnitFinder {
    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(clazz);
        if (runner == null || runner.getClass().isAssignableFrom(ErrorReportingRunner.class)) {
            return Collections.emptyList();
        }
        if (this.isParameterizedTest(runner)) {
            return this.handleParameterizedTest(clazz, runner.getDescription());
        }
        return Collections.emptyList();
    }

    private List<TestUnit> handleParameterizedTest(Class<?> clazz, Description description) {
        ArrayList<TestUnit> result = new ArrayList<TestUnit>();
        for (Description each : description.getChildren()) {
            FCollection.mapTo(each.getChildren(), this.parameterizedToTestUnit(clazz), result);
        }
        return result;
    }

    private F<Description, TestUnit> parameterizedToTestUnit(final Class<?> clazz) {
        return new F<Description, TestUnit>(){

            @Override
            public TestUnit apply(Description a) {
                return new AdaptedJUnitTestUnit(clazz, Option.some(new ParameterisedTestFilter(a.toString())));
            }
        };
    }

    private boolean isParameterizedTest(Runner runner) {
        return Parameterized.class.isAssignableFrom(runner.getClass());
    }
}

