/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import org.pitest.util.ExitCode;

public enum DetectionStatus {
    KILLED(true),
    SURVIVED(false),
    TIMED_OUT(true),
    NON_VIABLE(true),
    MEMORY_ERROR(true),
    NOT_STARTED(false),
    STARTED(false),
    RUN_ERROR(true),
    NO_COVERAGE(false);

    private final boolean detected;

    private DetectionStatus(boolean detected) {
        this.detected = detected;
    }

    public static DetectionStatus getForErrorExitCode(ExitCode exitCode) {
        if (exitCode.equals((Object)ExitCode.OUT_OF_MEMORY)) {
            return MEMORY_ERROR;
        }
        if (exitCode.equals((Object)ExitCode.TIMEOUT)) {
            return TIMED_OUT;
        }
        return RUN_ERROR;
    }

    public boolean isDetected() {
        return this.detected;
    }
}

