/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.ClassInfo;
import org.pitest.mutationtest.engine.gregor.blocks.BlockCounter;
import org.pitest.mutationtest.engine.gregor.blocks.ConcreteBlockCounter;

class ClassContext
implements BlockCounter {
    private ClassInfo classInfo;
    private String sourceFile;
    private Option<MutationIdentifier> target = Option.none();
    private final List<MutationDetails> mutations = new ArrayList<MutationDetails>();
    private final ConcreteBlockCounter blockCounter = new ConcreteBlockCounter();

    ClassContext() {
    }

    public Option<MutationIdentifier> getTargetMutation() {
        return this.target;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getJavaClassName() {
        return this.classInfo.getName().replace("/", ".");
    }

    public String getFileName() {
        return this.sourceFile;
    }

    public void setTargetMutation(Option<MutationIdentifier> target) {
        this.target = target;
    }

    public List<MutationDetails> getMutationDetails(MutationIdentifier id) {
        return FCollection.filter(this.mutations, ClassContext.hasId(id));
    }

    private static F<MutationDetails, Boolean> hasId(final MutationIdentifier id) {
        return new F<MutationDetails, Boolean>(){

            @Override
            public Boolean apply(MutationDetails a) {
                return a.matchesId(id);
            }
        };
    }

    public void registerClass(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public void registerSourceFile(String source) {
        this.sourceFile = source;
    }

    public boolean shouldMutate(MutationIdentifier newId) {
        return this.getTargetMutation().contains(ClassContext.idMatches(newId));
    }

    private static F<MutationIdentifier, Boolean> idMatches(final MutationIdentifier newId) {
        return new F<MutationIdentifier, Boolean>(){

            @Override
            public Boolean apply(MutationIdentifier a) {
                return a.matches(newId);
            }
        };
    }

    public Collection<MutationDetails> getCollectedMutations() {
        return this.mutations;
    }

    public void addMutation(MutationDetails details) {
        this.mutations.add(details);
    }

    @Override
    public void registerNewBlock() {
        this.blockCounter.registerNewBlock();
    }

    @Override
    public void registerFinallyBlockStart() {
        this.blockCounter.registerFinallyBlockStart();
    }

    @Override
    public void registerFinallyBlockEnd() {
        this.blockCounter.registerFinallyBlockEnd();
    }

    public int getCurrentBlock() {
        return this.blockCounter.getCurrentBlock();
    }

    public boolean isWithinFinallyBlock() {
        return this.blockCounter.isWithinFinallyBlock();
    }
}

