/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pitest.plugin.FeatureParameter;

public final class Feature {
    private final boolean onByDefault;
    private final String name;
    private final String description;
    private final List<FeatureParameter> params;

    private Feature(boolean onByDefault, String name, String description, List<FeatureParameter> params) {
        this.onByDefault = onByDefault;
        this.name = name;
        this.description = description;
        this.params = params;
    }

    public static Feature named(String name) {
        return new Feature(false, name, "", Collections.emptyList());
    }

    public Feature withOnByDefault(boolean onByDefault) {
        return new Feature(onByDefault, this.name, this.description, this.params);
    }

    public Feature withDescription(String description) {
        return new Feature(this.onByDefault, this.name, description, this.params);
    }

    public Feature withParameter(FeatureParameter param) {
        ArrayList<FeatureParameter> params = new ArrayList<FeatureParameter>();
        params.addAll(this.params);
        params.add(param);
        return new Feature(this.onByDefault, this.name, this.description, params);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean isOnByDefault() {
        return this.onByDefault;
    }

    public List<FeatureParameter> params() {
        return this.params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

