/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testng.FailFast;
import org.pitest.testng.MutableTestListenerWrapper;
import org.pitest.testng.TestNGAdapter;
import org.testng.IInvokedMethodListener;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGTestUnit
extends AbstractTestUnit {
    private static final TestNG TESTNG = new TestNG(false);
    private static final MutableTestListenerWrapper LISTENER = new MutableTestListenerWrapper();
    private final Class<?> clazz;
    private final TestGroupConfig config;
    private final Collection<String> includedTestMethods;

    public TestNGTestUnit(Class<?> clazz, TestGroupConfig config, Collection<String> includedTestMethods) {
        super(new Description("_", clazz));
        this.clazz = clazz;
        this.config = config;
        this.includedTestMethods = includedTestMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ResultCollector rc) {
        TestNG testNG = TESTNG;
        synchronized (testNG) {
            this.executeInCurrentLoader(rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInCurrentLoader(ResultCollector rc) {
        TestNGAdapter listener = new TestNGAdapter(this.clazz, this.getDescription(), rc);
        XmlSuite suite = this.createSuite();
        TESTNG.setDefaultSuiteName(suite.getName());
        TESTNG.setXmlSuites(Collections.singletonList(suite));
        LISTENER.setChild(listener);
        try {
            TESTNG.run();
        }
        finally {
            LISTENER.setChild(null);
        }
    }

    private XmlSuite createSuite() {
        XmlSuite suite = new XmlSuite();
        suite.setName(this.clazz.getName());
        suite.setSkipFailedInvocationCounts(true);
        XmlTest test = new XmlTest(suite);
        test.setName(this.clazz.getName());
        XmlClass xclass = new XmlClass(this.clazz.getName());
        test.setXmlClasses(Collections.singletonList(xclass));
        if (!this.includedTestMethods.isEmpty()) {
            ArrayList<XmlInclude> xmlIncludedTestMethods = new ArrayList<XmlInclude>();
            for (String includedTestMethod : this.includedTestMethods) {
                XmlInclude includedMethod = new XmlInclude(includedTestMethod);
                xmlIncludedTestMethods.add(includedMethod);
            }
            xclass.setIncludedMethods(xmlIncludedTestMethods);
        }
        if (!this.config.getExcludedGroups().isEmpty()) {
            suite.setExcludedGroups(this.config.getExcludedGroups());
        }
        if (!this.config.getIncludedGroups().isEmpty()) {
            suite.setIncludedGroups(this.config.getIncludedGroups());
        }
        return suite;
    }

    static {
        TESTNG.addListener((ITestListener)LISTENER);
        TESTNG.addInvokedMethodListener((IInvokedMethodListener)new FailFast(LISTENER));
    }
}

