/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

public class StringUtil {
    public static String join(Iterable<String> strings, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String s : strings) {
            sb.append(sep).append(s);
            sep = separator;
        }
        return sb.toString();
    }

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String separatorLine(char c) {
        return StringUtil.repeat(c, 80);
    }

    public static String separatorLine() {
        return StringUtil.repeat('-', 80);
    }

    public static String repeat(char c, int n) {
        return new String(new char[n]).replace('\u0000', c);
    }

    public static String escapeBasicHtmlChars(String s) {
        StringBuilder sb = new StringBuilder();
        StringUtil.escapeBasicHtmlChars(s, sb);
        return sb.toString();
    }

    public static void escapeBasicHtmlChars(String s, StringBuilder out) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char v = c;
            if (v < ' ' || v > '\u007f' || v == '&' || v == '\'' || v == '<' || v == '>' || v == '\"') {
                out.append('&');
                out.append('#');
                out.append((int)v);
                out.append(';');
                continue;
            }
            out.append(c);
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

