/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.util.Map;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.FixedSizeHashMap;
import org.pitest.functional.Option;

public class CachingByteArraySource
implements ClassByteArraySource {
    private final ClassByteArraySource child;
    private final Map<String, Option<byte[]>> cache;

    public CachingByteArraySource(ClassByteArraySource child, int maxSize) {
        this.child = child;
        this.cache = new FixedSizeHashMap<String, Option<byte[]>>(maxSize);
    }

    @Override
    public Option<byte[]> getBytes(String clazz) {
        Option<byte[]> maybeBytes = this.cache.get(clazz);
        if (maybeBytes != null) {
            return maybeBytes;
        }
        maybeBytes = this.child.getBytes(clazz);
        this.cache.put(clazz, maybeBytes);
        return maybeBytes;
    }
}

