/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.pitest.classpath.ArchiveClassPathRoot;
import org.pitest.classpath.ClassPathRoot;
import org.pitest.classpath.CompoundClassPathRoot;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Predicate;
import org.pitest.util.Log;
import org.pitest.util.PitError;
import org.pitest.util.StreamUtil;

public class ClassPath {
    private static final Logger LOG = Log.getLogger();
    private final CompoundClassPathRoot root;

    public ClassPath() {
        this(ClassPath.getClassPathElementsAsFiles());
    }

    public ClassPath(ClassPathRoot ... roots) {
        this(Arrays.asList(roots));
    }

    public ClassPath(Collection<File> files) {
        this(ClassPath.createRoots(FCollection.filter(files, ClassPath.exists())));
    }

    public ClassPath(List<ClassPathRoot> roots) {
        this.root = new CompoundClassPathRoot(roots);
    }

    public Collection<String> classNames() {
        return this.root.classNames();
    }

    private static List<ClassPathRoot> createRoots(Collection<File> files) {
        File lastFile = null;
        try {
            ArrayList<ClassPathRoot> rs = new ArrayList<ClassPathRoot>();
            Iterator<File> iterator = files.iterator();
            while (iterator.hasNext()) {
                File f;
                lastFile = f = iterator.next();
                if (f.isDirectory()) {
                    rs.add(new DirectoryClassPathRoot(f));
                    continue;
                }
                ClassPath.handleArchive(rs, f);
            }
            return rs;
        }
        catch (IOException ex) {
            throw new PitError("Error handling file " + lastFile, ex);
        }
    }

    private static void handleArchive(List<ClassPathRoot> rs, File f) throws IOException {
        try {
            if (!f.canRead()) {
                throw new IOException("Can't read the file " + f);
            }
            rs.add(new ArchiveClassPathRoot(f));
        }
        catch (ZipException ex) {
            LOG.warning("Can't open the archive " + f);
        }
    }

    public byte[] getClassData(String classname) throws IOException {
        try (InputStream is = this.root.getData(classname);){
            if (is != null) {
                byte[] byArray = StreamUtil.streamToByteArray(is);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    public URL findResource(String name) {
        try {
            return this.root.getResource(name);
        }
        catch (IOException exception) {
            return null;
        }
    }

    public static Collection<String> getClassPathElementsAsPaths() {
        LinkedHashSet<String> filesAsString = new LinkedHashSet<String>();
        FCollection.mapTo(ClassPath.getClassPathElementsAsFiles(), ClassPath.fileToString(), filesAsString);
        return filesAsString;
    }

    public static Collection<File> getClassPathElementsAsFiles() {
        LinkedHashSet<File> us = new LinkedHashSet<File>();
        FCollection.mapTo(ClassPath.getClassPathElementsAsAre(), ClassPath.stringToCanonicalFile(), us);
        return us;
    }

    public Collection<String> findClasses(Predicate<String> nameFilter) {
        return FCollection.filter(this.classNames(), nameFilter);
    }

    public String getLocalClassPath() {
        return this.root.cacheLocation().value();
    }

    public ClassPath getComponent(Predicate<ClassPathRoot> predicate) {
        return new ClassPath(FCollection.filter(this.root, predicate).toArray((ClassPathRoot[])new ClassPathRoot[0]));
    }

    private static F<File, Boolean> exists() {
        return new F<File, Boolean>(){

            @Override
            public Boolean apply(File a) {
                return a.exists() && a.canRead();
            }
        };
    }

    private static F<File, String> fileToString() {
        return new F<File, String>(){

            @Override
            public String apply(File file) {
                return file.getPath();
            }
        };
    }

    private static F<String, File> stringToCanonicalFile() {
        return new F<String, File>(){

            @Override
            public File apply(String fileAsString) {
                try {
                    return new File(fileAsString).getCanonicalFile();
                }
                catch (IOException ex) {
                    throw new PitError("Error transforming classpath element " + fileAsString, ex);
                }
            }
        };
    }

    private static List<String> getClassPathElementsAsAre() {
        String classPath = System.getProperty("java.class.path");
        String separator = File.pathSeparator;
        if (classPath != null) {
            return Arrays.asList(classPath.split(separator));
        }
        return new ArrayList<String>();
    }
}

